package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ImageChangeTriggerBuilder extends ImageChangeTriggerFluentImpl<ImageChangeTriggerBuilder> implements VisitableBuilder<ImageChangeTrigger,ImageChangeTriggerBuilder>{

     ImageChangeTriggerFluent<?> fluent;
public ImageChangeTriggerBuilder(){
    this(new ImageChangeTrigger());
}
public ImageChangeTriggerBuilder( ImageChangeTriggerFluent<?> fluent ){
    this(fluent, new ImageChangeTrigger());
}
public ImageChangeTriggerBuilder( ImageChangeTriggerFluent<?> fluent , ImageChangeTrigger instance ){
    this.fluent = fluent; fluent.withFrom(instance.getFrom()); fluent.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
}
public ImageChangeTriggerBuilder( ImageChangeTrigger instance ){
    this.fluent = this; this.withFrom(instance.getFrom()); this.withLastTriggeredImageID(instance.getLastTriggeredImageID()); 
}

public ImageChangeTrigger build(){
    ImageChangeTrigger buildable = new ImageChangeTrigger(fluent.getFrom(),fluent.getLastTriggeredImageID());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ImageChangeTriggerBuilder that = (ImageChangeTriggerBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
