package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ImageSourcePathBuilder extends ImageSourcePathFluentImpl<ImageSourcePathBuilder> implements VisitableBuilder<ImageSourcePath,ImageSourcePathBuilder>{

     ImageSourcePathFluent<?> fluent;
public ImageSourcePathBuilder(){
    this(new ImageSourcePath());
}
public ImageSourcePathBuilder( ImageSourcePathFluent<?> fluent ){
    this(fluent, new ImageSourcePath());
}
public ImageSourcePathBuilder( ImageSourcePathFluent<?> fluent , ImageSourcePath instance ){
    this.fluent = fluent; fluent.withDestinationDir(instance.getDestinationDir()); fluent.withSourcePath(instance.getSourcePath()); 
}
public ImageSourcePathBuilder( ImageSourcePath instance ){
    this.fluent = this; this.withDestinationDir(instance.getDestinationDir()); this.withSourcePath(instance.getSourcePath()); 
}

public ImageSourcePath build(){
    ImageSourcePath buildable = new ImageSourcePath(fluent.getDestinationDir(),fluent.getSourcePath());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ImageSourcePathBuilder that = (ImageSourcePathBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
