package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ImageSourcePathFluentImpl<A extends ImageSourcePathFluent<A>> extends BaseFluent<A> implements ImageSourcePathFluent<A>{

     String destinationDir;     String sourcePath;
public ImageSourcePathFluentImpl(){
    
}
public ImageSourcePathFluentImpl( ImageSourcePath instance ){
    this.withDestinationDir(instance.getDestinationDir()); this.withSourcePath(instance.getSourcePath()); 
}

    public String getDestinationDir(){
    return this.destinationDir;
    }
    public A withDestinationDir( String destinationDir){
    this.destinationDir=destinationDir; return (A) this;
    }
    public String getSourcePath(){
    return this.sourcePath;
    }
    public A withSourcePath( String sourcePath){
    this.sourcePath=sourcePath; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageSourcePathFluentImpl that = (ImageSourcePathFluentImpl) o;
if (destinationDir != null ? !destinationDir.equals(that.destinationDir) :that.destinationDir != null) return false;
if (sourcePath != null ? !sourcePath.equals(that.sourcePath) :that.sourcePath != null) return false;
return true;

    }



}
