package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class NamedClusterRoleFluentImpl<A extends NamedClusterRoleFluent<A>> extends BaseFluent<A> implements NamedClusterRoleFluent<A>{

     String name;     VisitableBuilder<ClusterRole, ?> role;
public NamedClusterRoleFluentImpl(){
    
}
public NamedClusterRoleFluentImpl( NamedClusterRole instance ){
    this.withName(instance.getName()); this.withRole(instance.getRole()); 
}

    public String getName(){
    return this.name;
    }
    public A withName( String name){
    this.name=name; return (A) this;
    }
    public ClusterRole getRole(){
    return this.role!=null?this.role.build():null;
    }
    public A withRole( ClusterRole role){
    if (role!=null){ this.role= new ClusterRoleBuilder(role); _visitables.add(this.role);} return (A) this;
    }
    public RoleNested<A> withNewRole(){
    return new RoleNestedImpl();
    }
    public RoleNested<A> withNewRoleLike( ClusterRole item){
    return new RoleNestedImpl(item);
    }
    public RoleNested<A> editRole(){
    return withNewRoleLike(getRole());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedClusterRoleFluentImpl that = (NamedClusterRoleFluentImpl) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (role != null ? !role.equals(that.role) :that.role != null) return false;
return true;

    }

    public class RoleNestedImpl<N> extends ClusterRoleFluentImpl<RoleNested<N>> implements RoleNested<N>{

        private final ClusterRoleBuilder builder;
    
             RoleNestedImpl (){
        this.builder = new ClusterRoleBuilder(this);
        }
             RoleNestedImpl ( ClusterRole item){
        this.builder = new ClusterRoleBuilder(this, item);
        }
    
            public N endRole(){
            return and();
        }
            public N and(){
            return (N) NamedClusterRoleFluentImpl.this.withRole(builder.build());
        }
    
}


}
