package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import java.util.List;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class NamedTagEventListFluentImpl<A extends NamedTagEventListFluent<A>> extends BaseFluent<A> implements NamedTagEventListFluent<A>{

     List<VisitableBuilder<TagEventCondition, ?>> conditions = new ArrayList();     List<VisitableBuilder<TagEvent, ?>> items = new ArrayList();     String tag;
public NamedTagEventListFluentImpl(){
    
}
public NamedTagEventListFluentImpl( NamedTagEventList instance ){
    this.withConditions(instance.getConditions()); this.withItems(instance.getItems()); this.withTag(instance.getTag()); 
}

    public A addToConditions( TagEventCondition ...items){
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }
    public A removeFromConditions( TagEventCondition ...items){
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (A)this;
    }
    public List<TagEventCondition> getConditions(){
    return build(conditions);
    }
    public A withConditions( List<TagEventCondition> conditions){
    this.conditions.clear();if (conditions != null) {for (TagEventCondition item : conditions){this.addToConditions(item);}} return (A) this;
    }
    public A withConditions( TagEventCondition ...conditions){
    this.conditions.clear(); if (conditions != null) {for (TagEventCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }
    public ConditionsNested<A> addNewCondition(){
    return new ConditionsNestedImpl();
    }
    public ConditionsNested<A> addNewConditionLike( TagEventCondition item){
    return new ConditionsNestedImpl(item);
    }
    public A addToItems( TagEvent ...items){
    for (TagEvent item : items) {TagEventBuilder builder = new TagEventBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }
    public A removeFromItems( TagEvent ...items){
    for (TagEvent item : items) {TagEventBuilder builder = new TagEventBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }
    public List<TagEvent> getItems(){
    return build(items);
    }
    public A withItems( List<TagEvent> items){
    this.items.clear();if (items != null) {for (TagEvent item : items){this.addToItems(item);}} return (A) this;
    }
    public A withItems( TagEvent ...items){
    this.items.clear(); if (items != null) {for (TagEvent item :items){ this.addToItems(item);}} return (A) this;
    }
    public ItemsNested<A> addNewItem(){
    return new ItemsNestedImpl();
    }
    public ItemsNested<A> addNewItemLike( TagEvent item){
    return new ItemsNestedImpl(item);
    }
    public A addNewItem( String created,  String dockerImageReference,  Long generation,  String image){
    return addToItems(new TagEvent(created, dockerImageReference, generation, image));
    }
    public String getTag(){
    return this.tag;
    }
    public A withTag( String tag){
    this.tag=tag; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedTagEventListFluentImpl that = (NamedTagEventListFluentImpl) o;
if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
return true;

    }

    public class ConditionsNestedImpl<N> extends TagEventConditionFluentImpl<ConditionsNested<N>> implements ConditionsNested<N>{

        private final TagEventConditionBuilder builder;
    
             ConditionsNestedImpl (){
        this.builder = new TagEventConditionBuilder(this);
        }
             ConditionsNestedImpl ( TagEventCondition item){
        this.builder = new TagEventConditionBuilder(this, item);
        }
    
            public N endCondition(){
            return and();
        }
            public N and(){
            return (N) NamedTagEventListFluentImpl.this.addToConditions(builder.build());
        }
    
}
    public class ItemsNestedImpl<N> extends TagEventFluentImpl<ItemsNested<N>> implements ItemsNested<N>{

        private final TagEventBuilder builder;
    
             ItemsNestedImpl (){
        this.builder = new TagEventBuilder(this);
        }
             ItemsNestedImpl ( TagEvent item){
        this.builder = new TagEventBuilder(this, item);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) NamedTagEventListFluentImpl.this.addToItems(builder.build());
        }
    
}


}
