package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface OAuthClientFluent<A extends OAuthClientFluent<A>> extends Fluent<A>{


    public A addToAdditionalSecrets( String ...items);    public A removeFromAdditionalSecrets( String ...items);    public List<String> getAdditionalSecrets();    public A withAdditionalSecrets( List<String> additionalSecrets);    public A withAdditionalSecrets( String ...additionalSecrets);    public String getApiVersion();    public A withApiVersion( String apiVersion);    public String getKind();    public A withKind( String kind);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();    public A addToRedirectURIs( String ...items);    public A removeFromRedirectURIs( String ...items);    public List<String> getRedirectURIs();    public A withRedirectURIs( List<String> redirectURIs);    public A withRedirectURIs( String ...redirectURIs);    public Boolean isRespondWithChallenges();    public A withRespondWithChallenges( Boolean respondWithChallenges);    public A addToScopeRestrictions( ScopeRestriction ...items);    public A removeFromScopeRestrictions( ScopeRestriction ...items);    public List<ScopeRestriction> getScopeRestrictions();    public A withScopeRestrictions( List<ScopeRestriction> scopeRestrictions);    public A withScopeRestrictions( ScopeRestriction ...scopeRestrictions);    public ScopeRestrictionsNested<A> addNewScopeRestriction();    public ScopeRestrictionsNested<A> addNewScopeRestrictionLike( ScopeRestriction item);    public String getSecret();    public A withSecret( String secret);
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface ScopeRestrictionsNested<N> extends Nested<N>,ScopeRestrictionFluent<ScopeRestrictionsNested<N>>{
            public N endScopeRestriction();            public N and();        
}


}
