package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ListMetaFluent;

public class OAuthClientListFluentImpl<A extends OAuthClientListFluent<A>> extends BaseFluent<A> implements OAuthClientListFluent<A>{

     String apiVersion;     List<VisitableBuilder<OAuthClient, ?>> items = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;
public OAuthClientListFluentImpl(){
    
}
public OAuthClientListFluentImpl( OAuthClientList instance ){
    this.withApiVersion(instance.getApiVersion()); this.withItems(instance.getItems()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public A addToItems( OAuthClient ...items){
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }
    public A removeFromItems( OAuthClient ...items){
    for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }
    public List<OAuthClient> getItems(){
    return build(items);
    }
    public A withItems( List<OAuthClient> items){
    this.items.clear();if (items != null) {for (OAuthClient item : items){this.addToItems(item);}} return (A) this;
    }
    public A withItems( OAuthClient ...items){
    this.items.clear(); if (items != null) {for (OAuthClient item :items){ this.addToItems(item);}} return (A) this;
    }
    public ItemsNested<A> addNewItem(){
    return new ItemsNestedImpl();
    }
    public ItemsNested<A> addNewItemLike( OAuthClient item){
    return new ItemsNestedImpl(item);
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ListMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public A withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
OAuthClientListFluentImpl that = (OAuthClientListFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
return true;

    }

    public class ItemsNestedImpl<N> extends OAuthClientFluentImpl<ItemsNested<N>> implements ItemsNested<N>{

        private final OAuthClientBuilder builder;
    
             ItemsNestedImpl (){
        this.builder = new OAuthClientBuilder(this);
        }
             ItemsNestedImpl ( OAuthClient item){
        this.builder = new OAuthClientBuilder(this, item);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) OAuthClientListFluentImpl.this.addToItems(builder.build());
        }
    
}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ListMetaBuilder(this);
        }
             MetadataNestedImpl ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) OAuthClientListFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
