package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class PolicyFluentImpl<A extends PolicyFluent<A>> extends BaseFluent<A> implements PolicyFluent<A>{

     String apiVersion;     String kind;     String lastModified;     VisitableBuilder<ObjectMeta, ?> metadata;     List<VisitableBuilder<NamedRole, ?>> roles = new ArrayList();
public PolicyFluentImpl(){
    
}
public PolicyFluentImpl( Policy instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withLastModified(instance.getLastModified()); this.withMetadata(instance.getMetadata()); this.withRoles(instance.getRoles()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public String getLastModified(){
    return this.lastModified;
    }
    public A withLastModified( String lastModified){
    this.lastModified=lastModified; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public A addToRoles( NamedRole ...items){
    for (NamedRole item : items) {NamedRoleBuilder builder = new NamedRoleBuilder(item);_visitables.add(builder);this.roles.add(builder);} return (A)this;
    }
    public A removeFromRoles( NamedRole ...items){
    for (NamedRole item : items) {NamedRoleBuilder builder = new NamedRoleBuilder(item);_visitables.remove(builder);this.roles.remove(builder);} return (A)this;
    }
    public List<NamedRole> getRoles(){
    return build(roles);
    }
    public A withRoles( List<NamedRole> roles){
    this.roles.clear();if (roles != null) {for (NamedRole item : roles){this.addToRoles(item);}} return (A) this;
    }
    public A withRoles( NamedRole ...roles){
    this.roles.clear(); if (roles != null) {for (NamedRole item :roles){ this.addToRoles(item);}} return (A) this;
    }
    public RolesNested<A> addNewRole(){
    return new RolesNestedImpl();
    }
    public RolesNested<A> addNewRoleLike( NamedRole item){
    return new RolesNestedImpl(item);
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PolicyFluentImpl that = (PolicyFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (lastModified != null ? !lastModified.equals(that.lastModified) :that.lastModified != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (roles != null ? !roles.equals(that.roles) :that.roles != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) PolicyFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class RolesNestedImpl<N> extends NamedRoleFluentImpl<RolesNested<N>> implements RolesNested<N>{

        private final NamedRoleBuilder builder;
    
             RolesNestedImpl (){
        this.builder = new NamedRoleBuilder(this);
        }
             RolesNestedImpl ( NamedRole item){
        this.builder = new NamedRoleBuilder(this, item);
        }
    
            public N endRole(){
            return and();
        }
            public N and(){
            return (N) PolicyFluentImpl.this.addToRoles(builder.build());
        }
    
}


}
