package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class RoleFluentImpl<A extends RoleFluent<A>> extends BaseFluent<A> implements RoleFluent<A>{

     String apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<VisitableBuilder<PolicyRule, ?>> rules = new ArrayList();
public RoleFluentImpl(){
    
}
public RoleFluentImpl( Role instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRules(instance.getRules()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public A addToRules( PolicyRule ...items){
    for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.add(builder);this.rules.add(builder);} return (A)this;
    }
    public A removeFromRules( PolicyRule ...items){
    for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.remove(builder);this.rules.remove(builder);} return (A)this;
    }
    public List<PolicyRule> getRules(){
    return build(rules);
    }
    public A withRules( List<PolicyRule> rules){
    this.rules.clear();if (rules != null) {for (PolicyRule item : rules){this.addToRules(item);}} return (A) this;
    }
    public A withRules( PolicyRule ...rules){
    this.rules.clear(); if (rules != null) {for (PolicyRule item :rules){ this.addToRules(item);}} return (A) this;
    }
    public RulesNested<A> addNewRule(){
    return new RulesNestedImpl();
    }
    public RulesNested<A> addNewRuleLike( PolicyRule item){
    return new RulesNestedImpl(item);
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RoleFluentImpl that = (RoleFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) RoleFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class RulesNestedImpl<N> extends PolicyRuleFluentImpl<RulesNested<N>> implements RulesNested<N>{

        private final PolicyRuleBuilder builder;
    
             RulesNestedImpl (){
        this.builder = new PolicyRuleBuilder(this);
        }
             RulesNestedImpl ( PolicyRule item){
        this.builder = new PolicyRuleBuilder(this, item);
        }
    
            public N and(){
            return (N) RoleFluentImpl.this.addToRules(builder.build());
        }
            public N endRule(){
            return and();
        }
    
}


}
