package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.Map;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;

public class RollingDeploymentStrategyParamsFluentImpl<A extends RollingDeploymentStrategyParamsFluent<A>> extends BaseFluent<A> implements RollingDeploymentStrategyParamsFluent<A>{

     Long intervalSeconds;     VisitableBuilder<IntOrString, ?> maxSurge;     VisitableBuilder<IntOrString, ?> maxUnavailable;     VisitableBuilder<LifecycleHook, ?> post;     VisitableBuilder<LifecycleHook, ?> pre;     Long timeoutSeconds;     Integer updatePercent;     Long updatePeriodSeconds;
public RollingDeploymentStrategyParamsFluentImpl(){
    
}
public RollingDeploymentStrategyParamsFluentImpl( RollingDeploymentStrategyParams instance ){
    this.withIntervalSeconds(instance.getIntervalSeconds()); this.withMaxSurge(instance.getMaxSurge()); this.withMaxUnavailable(instance.getMaxUnavailable()); this.withPost(instance.getPost()); this.withPre(instance.getPre()); this.withTimeoutSeconds(instance.getTimeoutSeconds()); this.withUpdatePercent(instance.getUpdatePercent()); this.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
}

    public Long getIntervalSeconds(){
    return this.intervalSeconds;
    }
    public A withIntervalSeconds( Long intervalSeconds){
    this.intervalSeconds=intervalSeconds; return (A) this;
    }
    public IntOrString getMaxSurge(){
    return this.maxSurge!=null?this.maxSurge.build():null;
    }
    public A withMaxSurge( IntOrString maxSurge){
    if (maxSurge!=null){ this.maxSurge= new IntOrStringBuilder(maxSurge); _visitables.add(this.maxSurge);} return (A) this;
    }
    public MaxSurgeNested<A> withNewMaxSurge(){
    return new MaxSurgeNestedImpl();
    }
    public MaxSurgeNested<A> withNewMaxSurgeLike( IntOrString item){
    return new MaxSurgeNestedImpl(item);
    }
    public MaxSurgeNested<A> editMaxSurge(){
    return withNewMaxSurgeLike(getMaxSurge());
    }
    public A withNewMaxSurge( String strVal){
    return withMaxSurge(new IntOrString(strVal));
    }
    public A withNewMaxSurge( Integer intVal){
    return withMaxSurge(new IntOrString(intVal));
    }
    public IntOrString getMaxUnavailable(){
    return this.maxUnavailable!=null?this.maxUnavailable.build():null;
    }
    public A withMaxUnavailable( IntOrString maxUnavailable){
    if (maxUnavailable!=null){ this.maxUnavailable= new IntOrStringBuilder(maxUnavailable); _visitables.add(this.maxUnavailable);} return (A) this;
    }
    public MaxUnavailableNested<A> withNewMaxUnavailable(){
    return new MaxUnavailableNestedImpl();
    }
    public MaxUnavailableNested<A> withNewMaxUnavailableLike( IntOrString item){
    return new MaxUnavailableNestedImpl(item);
    }
    public MaxUnavailableNested<A> editMaxUnavailable(){
    return withNewMaxUnavailableLike(getMaxUnavailable());
    }
    public A withNewMaxUnavailable( String strVal){
    return withMaxUnavailable(new IntOrString(strVal));
    }
    public A withNewMaxUnavailable( Integer intVal){
    return withMaxUnavailable(new IntOrString(intVal));
    }
    public LifecycleHook getPost(){
    return this.post!=null?this.post.build():null;
    }
    public A withPost( LifecycleHook post){
    if (post!=null){ this.post= new LifecycleHookBuilder(post); _visitables.add(this.post);} return (A) this;
    }
    public PostNested<A> withNewPost(){
    return new PostNestedImpl();
    }
    public PostNested<A> withNewPostLike( LifecycleHook item){
    return new PostNestedImpl(item);
    }
    public PostNested<A> editPost(){
    return withNewPostLike(getPost());
    }
    public LifecycleHook getPre(){
    return this.pre!=null?this.pre.build():null;
    }
    public A withPre( LifecycleHook pre){
    if (pre!=null){ this.pre= new LifecycleHookBuilder(pre); _visitables.add(this.pre);} return (A) this;
    }
    public PreNested<A> withNewPre(){
    return new PreNestedImpl();
    }
    public PreNested<A> withNewPreLike( LifecycleHook item){
    return new PreNestedImpl(item);
    }
    public PreNested<A> editPre(){
    return withNewPreLike(getPre());
    }
    public Long getTimeoutSeconds(){
    return this.timeoutSeconds;
    }
    public A withTimeoutSeconds( Long timeoutSeconds){
    this.timeoutSeconds=timeoutSeconds; return (A) this;
    }
    public Integer getUpdatePercent(){
    return this.updatePercent;
    }
    public A withUpdatePercent( Integer updatePercent){
    this.updatePercent=updatePercent; return (A) this;
    }
    public Long getUpdatePeriodSeconds(){
    return this.updatePeriodSeconds;
    }
    public A withUpdatePeriodSeconds( Long updatePeriodSeconds){
    this.updatePeriodSeconds=updatePeriodSeconds; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RollingDeploymentStrategyParamsFluentImpl that = (RollingDeploymentStrategyParamsFluentImpl) o;
if (intervalSeconds != null ? !intervalSeconds.equals(that.intervalSeconds) :that.intervalSeconds != null) return false;
if (maxSurge != null ? !maxSurge.equals(that.maxSurge) :that.maxSurge != null) return false;
if (maxUnavailable != null ? !maxUnavailable.equals(that.maxUnavailable) :that.maxUnavailable != null) return false;
if (post != null ? !post.equals(that.post) :that.post != null) return false;
if (pre != null ? !pre.equals(that.pre) :that.pre != null) return false;
if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
if (updatePercent != null ? !updatePercent.equals(that.updatePercent) :that.updatePercent != null) return false;
if (updatePeriodSeconds != null ? !updatePeriodSeconds.equals(that.updatePeriodSeconds) :that.updatePeriodSeconds != null) return false;
return true;

    }

    public class MaxSurgeNestedImpl<N> extends IntOrStringFluentImpl<MaxSurgeNested<N>> implements MaxSurgeNested<N>{

        private final IntOrStringBuilder builder;
    
             MaxSurgeNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             MaxSurgeNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N and(){
            return (N) RollingDeploymentStrategyParamsFluentImpl.this.withMaxSurge(builder.build());
        }
            public N endMaxSurge(){
            return and();
        }
    
}
    public class MaxUnavailableNestedImpl<N> extends IntOrStringFluentImpl<MaxUnavailableNested<N>> implements MaxUnavailableNested<N>{

        private final IntOrStringBuilder builder;
    
             MaxUnavailableNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             MaxUnavailableNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N endMaxUnavailable(){
            return and();
        }
            public N and(){
            return (N) RollingDeploymentStrategyParamsFluentImpl.this.withMaxUnavailable(builder.build());
        }
    
}
    public class PostNestedImpl<N> extends LifecycleHookFluentImpl<PostNested<N>> implements PostNested<N>{

        private final LifecycleHookBuilder builder;
    
             PostNestedImpl (){
        this.builder = new LifecycleHookBuilder(this);
        }
             PostNestedImpl ( LifecycleHook item){
        this.builder = new LifecycleHookBuilder(this, item);
        }
    
            public N endPost(){
            return and();
        }
            public N and(){
            return (N) RollingDeploymentStrategyParamsFluentImpl.this.withPost(builder.build());
        }
    
}
    public class PreNestedImpl<N> extends LifecycleHookFluentImpl<PreNested<N>> implements PreNested<N>{

        private final LifecycleHookBuilder builder;
    
             PreNestedImpl (){
        this.builder = new LifecycleHookBuilder(this);
        }
             PreNestedImpl ( LifecycleHook item){
        this.builder = new LifecycleHookBuilder(this, item);
        }
    
            public N and(){
            return (N) RollingDeploymentStrategyParamsFluentImpl.this.withPre(builder.build());
        }
            public N endPre(){
            return and();
        }
    
}


}
