package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class RouteSpecFluentImpl<A extends RouteSpecFluent<A>> extends BaseFluent<A> implements RouteSpecFluent<A>{

     String host;     String path;     VisitableBuilder<RoutePort, ?> port;     VisitableBuilder<TLSConfig, ?> tls;     VisitableBuilder<ObjectReference, ?> to;
public RouteSpecFluentImpl(){
    
}
public RouteSpecFluentImpl( RouteSpec instance ){
    this.withHost(instance.getHost()); this.withPath(instance.getPath()); this.withPort(instance.getPort()); this.withTls(instance.getTls()); this.withTo(instance.getTo()); 
}

    public String getHost(){
    return this.host;
    }
    public A withHost( String host){
    this.host=host; return (A) this;
    }
    public String getPath(){
    return this.path;
    }
    public A withPath( String path){
    this.path=path; return (A) this;
    }
    public RoutePort getPort(){
    return this.port!=null?this.port.build():null;
    }
    public A withPort( RoutePort port){
    if (port!=null){ this.port= new RoutePortBuilder(port); _visitables.add(this.port);} return (A) this;
    }
    public PortNested<A> withNewPort(){
    return new PortNestedImpl();
    }
    public PortNested<A> withNewPortLike( RoutePort item){
    return new PortNestedImpl(item);
    }
    public PortNested<A> editPort(){
    return withNewPortLike(getPort());
    }
    public TLSConfig getTls(){
    return this.tls!=null?this.tls.build():null;
    }
    public A withTls( TLSConfig tls){
    if (tls!=null){ this.tls= new TLSConfigBuilder(tls); _visitables.add(this.tls);} return (A) this;
    }
    public TlsNested<A> withNewTls(){
    return new TlsNestedImpl();
    }
    public TlsNested<A> withNewTlsLike( TLSConfig item){
    return new TlsNestedImpl(item);
    }
    public TlsNested<A> editTls(){
    return withNewTlsLike(getTls());
    }
    public ObjectReference getTo(){
    return this.to!=null?this.to.build():null;
    }
    public A withTo( ObjectReference to){
    if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.add(this.to);} return (A) this;
    }
    public ToNested<A> withNewTo(){
    return new ToNestedImpl();
    }
    public ToNested<A> withNewToLike( ObjectReference item){
    return new ToNestedImpl(item);
    }
    public ToNested<A> editTo(){
    return withNewToLike(getTo());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RouteSpecFluentImpl that = (RouteSpecFluentImpl) o;
if (host != null ? !host.equals(that.host) :that.host != null) return false;
if (path != null ? !path.equals(that.path) :that.path != null) return false;
if (port != null ? !port.equals(that.port) :that.port != null) return false;
if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
if (to != null ? !to.equals(that.to) :that.to != null) return false;
return true;

    }

    public class PortNestedImpl<N> extends RoutePortFluentImpl<PortNested<N>> implements PortNested<N>{

        private final RoutePortBuilder builder;
    
             PortNestedImpl (){
        this.builder = new RoutePortBuilder(this);
        }
             PortNestedImpl ( RoutePort item){
        this.builder = new RoutePortBuilder(this, item);
        }
    
            public N endPort(){
            return and();
        }
            public N and(){
            return (N) RouteSpecFluentImpl.this.withPort(builder.build());
        }
    
}
    public class TlsNestedImpl<N> extends TLSConfigFluentImpl<TlsNested<N>> implements TlsNested<N>{

        private final TLSConfigBuilder builder;
    
             TlsNestedImpl (){
        this.builder = new TLSConfigBuilder(this);
        }
             TlsNestedImpl ( TLSConfig item){
        this.builder = new TLSConfigBuilder(this, item);
        }
    
            public N endTls(){
            return and();
        }
            public N and(){
            return (N) RouteSpecFluentImpl.this.withTls(builder.build());
        }
    
}
    public class ToNestedImpl<N> extends ObjectReferenceFluentImpl<ToNested<N>> implements ToNested<N>{

        private final ObjectReferenceBuilder builder;
    
             ToNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ToNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) RouteSpecFluentImpl.this.withTo(builder.build());
        }
            public N endTo(){
            return and();
        }
    
}


}
