package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.List;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class SourceBuildStrategyBuilder extends SourceBuildStrategyFluentImpl<SourceBuildStrategyBuilder> implements VisitableBuilder<SourceBuildStrategy,SourceBuildStrategyBuilder>{

     SourceBuildStrategyFluent<?> fluent;
public SourceBuildStrategyBuilder(){
    this(new SourceBuildStrategy());
}
public SourceBuildStrategyBuilder( SourceBuildStrategyFluent<?> fluent ){
    this(fluent, new SourceBuildStrategy());
}
public SourceBuildStrategyBuilder( SourceBuildStrategyFluent<?> fluent , SourceBuildStrategy instance ){
    this.fluent = fluent; fluent.withEnv(instance.getEnv()); fluent.withForcePull(instance.getForcePull()); fluent.withFrom(instance.getFrom()); fluent.withIncremental(instance.getIncremental()); fluent.withPullSecret(instance.getPullSecret()); fluent.withScripts(instance.getScripts()); 
}
public SourceBuildStrategyBuilder( SourceBuildStrategy instance ){
    this.fluent = this; this.withEnv(instance.getEnv()); this.withForcePull(instance.getForcePull()); this.withFrom(instance.getFrom()); this.withIncremental(instance.getIncremental()); this.withPullSecret(instance.getPullSecret()); this.withScripts(instance.getScripts()); 
}

public SourceBuildStrategy build(){
    SourceBuildStrategy buildable = new SourceBuildStrategy(fluent.getEnv(),fluent.isForcePull(),fluent.getFrom(),fluent.isIncremental(),fluent.getPullSecret(),fluent.getScripts());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
SourceBuildStrategyBuilder that = (SourceBuildStrategyBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
