package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class SubjectAccessReviewFluentImpl<A extends SubjectAccessReviewFluent<A>> extends BaseFluent<A> implements SubjectAccessReviewFluent<A>{

     String apiVersion;     HasMetadata content;     List<String> groups = new ArrayList();     String kind;     String namespace;     String resource;     String resourceAPIGroup;     String resourceAPIVersion;     String resourceName;     List<String> scopes = new ArrayList();     String user;     String verb;
public SubjectAccessReviewFluentImpl(){
    
}
public SubjectAccessReviewFluentImpl( SubjectAccessReview instance ){
    this.withApiVersion(instance.getApiVersion()); this.withContent(instance.getContent()); this.withGroups(instance.getGroups()); this.withKind(instance.getKind()); this.withNamespace(instance.getNamespace()); this.withResource(instance.getResource()); this.withResourceAPIGroup(instance.getResourceAPIGroup()); this.withResourceAPIVersion(instance.getResourceAPIVersion()); this.withResourceName(instance.getResourceName()); this.withScopes(instance.getScopes()); this.withUser(instance.getUser()); this.withVerb(instance.getVerb()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public HasMetadata getContent(){
    return this.content;
    }
    public A withContent( HasMetadata content){
    this.content=content; return (A) this;
    }
    public A addToGroups( String ...items){
    for (String item : items) {this.groups.add(item);} return (A)this;
    }
    public A removeFromGroups( String ...items){
    for (String item : items) {this.groups.remove(item);} return (A)this;
    }
    public List<String> getGroups(){
    return this.groups;
    }
    public A withGroups( List<String> groups){
    this.groups.clear();if (groups != null) {for (String item : groups){this.addToGroups(item);}} return (A) this;
    }
    public A withGroups( String ...groups){
    this.groups.clear(); if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public String getNamespace(){
    return this.namespace;
    }
    public A withNamespace( String namespace){
    this.namespace=namespace; return (A) this;
    }
    public String getResource(){
    return this.resource;
    }
    public A withResource( String resource){
    this.resource=resource; return (A) this;
    }
    public String getResourceAPIGroup(){
    return this.resourceAPIGroup;
    }
    public A withResourceAPIGroup( String resourceAPIGroup){
    this.resourceAPIGroup=resourceAPIGroup; return (A) this;
    }
    public String getResourceAPIVersion(){
    return this.resourceAPIVersion;
    }
    public A withResourceAPIVersion( String resourceAPIVersion){
    this.resourceAPIVersion=resourceAPIVersion; return (A) this;
    }
    public String getResourceName(){
    return this.resourceName;
    }
    public A withResourceName( String resourceName){
    this.resourceName=resourceName; return (A) this;
    }
    public A addToScopes( String ...items){
    for (String item : items) {this.scopes.add(item);} return (A)this;
    }
    public A removeFromScopes( String ...items){
    for (String item : items) {this.scopes.remove(item);} return (A)this;
    }
    public List<String> getScopes(){
    return this.scopes;
    }
    public A withScopes( List<String> scopes){
    this.scopes.clear();if (scopes != null) {for (String item : scopes){this.addToScopes(item);}} return (A) this;
    }
    public A withScopes( String ...scopes){
    this.scopes.clear(); if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
    }
    public String getUser(){
    return this.user;
    }
    public A withUser( String user){
    this.user=user; return (A) this;
    }
    public String getVerb(){
    return this.verb;
    }
    public A withVerb( String verb){
    this.verb=verb; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SubjectAccessReviewFluentImpl that = (SubjectAccessReviewFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (content != null ? !content.equals(that.content) :that.content != null) return false;
if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
if (resourceAPIGroup != null ? !resourceAPIGroup.equals(that.resourceAPIGroup) :that.resourceAPIGroup != null) return false;
if (resourceAPIVersion != null ? !resourceAPIVersion.equals(that.resourceAPIVersion) :that.resourceAPIVersion != null) return false;
if (resourceName != null ? !resourceName.equals(that.resourceName) :that.resourceName != null) return false;
if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
if (verb != null ? !verb.equals(that.verb) :that.verb != null) return false;
return true;

    }



}
