package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class TagImageHookFluentImpl<A extends TagImageHookFluent<A>> extends BaseFluent<A> implements TagImageHookFluent<A>{

     String containerName;     VisitableBuilder<ObjectReference, ?> to;
public TagImageHookFluentImpl(){
    
}
public TagImageHookFluentImpl( TagImageHook instance ){
    this.withContainerName(instance.getContainerName()); this.withTo(instance.getTo()); 
}

    public String getContainerName(){
    return this.containerName;
    }
    public A withContainerName( String containerName){
    this.containerName=containerName; return (A) this;
    }
    public ObjectReference getTo(){
    return this.to!=null?this.to.build():null;
    }
    public A withTo( ObjectReference to){
    if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.add(this.to);} return (A) this;
    }
    public ToNested<A> withNewTo(){
    return new ToNestedImpl();
    }
    public ToNested<A> withNewToLike( ObjectReference item){
    return new ToNestedImpl(item);
    }
    public ToNested<A> editTo(){
    return withNewToLike(getTo());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
TagImageHookFluentImpl that = (TagImageHookFluentImpl) o;
if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
if (to != null ? !to.equals(that.to) :that.to != null) return false;
return true;

    }

    public class ToNestedImpl<N> extends ObjectReferenceFluentImpl<ToNested<N>> implements ToNested<N>{

        private final ObjectReferenceBuilder builder;
    
             ToNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ToNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) TagImageHookFluentImpl.this.withTo(builder.build());
        }
            public N endTo(){
            return and();
        }
    
}


}
