package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class TagReferenceFluentImpl<A extends TagReferenceFluent<A>> extends BaseFluent<A> implements TagReferenceFluent<A>{

     Map<String, String> annotations = new HashMap();     VisitableBuilder<ObjectReference, ?> from;     Long generation;     VisitableBuilder<TagImportPolicy, ?> importPolicy;     String name;     Boolean reference;
public TagReferenceFluentImpl(){
    
}
public TagReferenceFluentImpl( TagReference instance ){
    this.withAnnotations(instance.getAnnotations()); this.withFrom(instance.getFrom()); this.withGeneration(instance.getGeneration()); this.withImportPolicy(instance.getImportPolicy()); this.withName(instance.getName()); this.withReference(instance.getReference()); 
}

    public A addToAnnotations( String key,  String value){
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }
    public A addToAnnotations( Map<String, String> map){
    if(map != null) { this.annotations.putAll(map);} return (A)this;
    }
    public A removeFromAnnotations( String key){
    if(key != null) {this.annotations.remove(key);} return (A)this;
    }
    public A removeFromAnnotations( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.annotations.remove(key);}} return (A)this;
    }
    public Map<String, String> getAnnotations(){
    return this.annotations;
    }
    public A withAnnotations( Map<String, String> annotations){
    this.annotations.clear();if (annotations != null) {this.annotations.putAll(annotations);} return (A) this;
    }
    public ObjectReference getFrom(){
    return this.from!=null?this.from.build():null;
    }
    public A withFrom( ObjectReference from){
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (A) this;
    }
    public FromNested<A> withNewFrom(){
    return new FromNestedImpl();
    }
    public FromNested<A> withNewFromLike( ObjectReference item){
    return new FromNestedImpl(item);
    }
    public FromNested<A> editFrom(){
    return withNewFromLike(getFrom());
    }
    public Long getGeneration(){
    return this.generation;
    }
    public A withGeneration( Long generation){
    this.generation=generation; return (A) this;
    }
    public TagImportPolicy getImportPolicy(){
    return this.importPolicy!=null?this.importPolicy.build():null;
    }
    public A withImportPolicy( TagImportPolicy importPolicy){
    if (importPolicy!=null){ this.importPolicy= new TagImportPolicyBuilder(importPolicy); _visitables.add(this.importPolicy);} return (A) this;
    }
    public ImportPolicyNested<A> withNewImportPolicy(){
    return new ImportPolicyNestedImpl();
    }
    public ImportPolicyNested<A> withNewImportPolicyLike( TagImportPolicy item){
    return new ImportPolicyNestedImpl(item);
    }
    public ImportPolicyNested<A> editImportPolicy(){
    return withNewImportPolicyLike(getImportPolicy());
    }
    public A withNewImportPolicy( Boolean insecure,  Boolean scheduled){
    return withImportPolicy(new TagImportPolicy(insecure, scheduled));
    }
    public String getName(){
    return this.name;
    }
    public A withName( String name){
    this.name=name; return (A) this;
    }
    public Boolean isReference(){
    return this.reference;
    }
    public A withReference( Boolean reference){
    this.reference=reference; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
TagReferenceFluentImpl that = (TagReferenceFluentImpl) o;
if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
if (from != null ? !from.equals(that.from) :that.from != null) return false;
if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
if (importPolicy != null ? !importPolicy.equals(that.importPolicy) :that.importPolicy != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (reference != null ? !reference.equals(that.reference) :that.reference != null) return false;
return true;

    }

    public class FromNestedImpl<N> extends ObjectReferenceFluentImpl<FromNested<N>> implements FromNested<N>{

        private final ObjectReferenceBuilder builder;
    
             FromNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             FromNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endFrom(){
            return and();
        }
            public N and(){
            return (N) TagReferenceFluentImpl.this.withFrom(builder.build());
        }
    
}
    public class ImportPolicyNestedImpl<N> extends TagImportPolicyFluentImpl<ImportPolicyNested<N>> implements ImportPolicyNested<N>{

        private final TagImportPolicyBuilder builder;
    
             ImportPolicyNestedImpl (){
        this.builder = new TagImportPolicyBuilder(this);
        }
             ImportPolicyNestedImpl ( TagImportPolicy item){
        this.builder = new TagImportPolicyBuilder(this, item);
        }
    
            public N endImportPolicy(){
            return and();
        }
            public N and(){
            return (N) TagReferenceFluentImpl.this.withImportPolicy(builder.build());
        }
    
}


}
