package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class UserFluentImpl<A extends UserFluent<A>> extends BaseFluent<A> implements UserFluent<A>{

     String apiVersion;     String fullName;     List<String> groups = new ArrayList();     List<String> identities = new ArrayList();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;
public UserFluentImpl(){
    
}
public UserFluentImpl( User instance ){
    this.withApiVersion(instance.getApiVersion()); this.withFullName(instance.getFullName()); this.withGroups(instance.getGroups()); this.withIdentities(instance.getIdentities()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getFullName(){
    return this.fullName;
    }
    public A withFullName( String fullName){
    this.fullName=fullName; return (A) this;
    }
    public A addToGroups( String ...items){
    for (String item : items) {this.groups.add(item);} return (A)this;
    }
    public A removeFromGroups( String ...items){
    for (String item : items) {this.groups.remove(item);} return (A)this;
    }
    public List<String> getGroups(){
    return this.groups;
    }
    public A withGroups( List<String> groups){
    this.groups.clear();if (groups != null) {for (String item : groups){this.addToGroups(item);}} return (A) this;
    }
    public A withGroups( String ...groups){
    this.groups.clear(); if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
    }
    public A addToIdentities( String ...items){
    for (String item : items) {this.identities.add(item);} return (A)this;
    }
    public A removeFromIdentities( String ...items){
    for (String item : items) {this.identities.remove(item);} return (A)this;
    }
    public List<String> getIdentities(){
    return this.identities;
    }
    public A withIdentities( List<String> identities){
    this.identities.clear();if (identities != null) {for (String item : identities){this.addToIdentities(item);}} return (A) this;
    }
    public A withIdentities( String ...identities){
    this.identities.clear(); if (identities != null) {for (String item :identities){ this.addToIdentities(item);}} return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
UserFluentImpl that = (UserFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (fullName != null ? !fullName.equals(that.fullName) :that.fullName != null) return false;
if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
if (identities != null ? !identities.equals(that.identities) :that.identities != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) UserFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
