package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ComponentStatusFluent<A extends ComponentStatusFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public A addToConditions( ComponentCondition ...items);    public A removeFromConditions( ComponentCondition ...items);    public List<ComponentCondition> getConditions();    public A withConditions( List<ComponentCondition> conditions);    public A withConditions( ComponentCondition ...conditions);    public ConditionsNested<A> addNewCondition();    public ConditionsNested<A> addNewConditionLike( ComponentCondition item);    public A addNewCondition( String error,  String message,  String status,  String type);    public String getKind();    public A withKind( String kind);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();
    public interface ConditionsNested<N> extends Nested<N>,ComponentConditionFluent<ConditionsNested<N>>{
            public N endCondition();            public N and();        
}

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
