package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import java.util.List;

public class ComponentStatusFluentImpl<A extends ComponentStatusFluent<A>> extends BaseFluent<A> implements ComponentStatusFluent<A>{

     String apiVersion;     List<VisitableBuilder<ComponentCondition, ?>> conditions = new ArrayList();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;
public ComponentStatusFluentImpl(){
    
}
public ComponentStatusFluentImpl( ComponentStatus instance ){
    this.withApiVersion(instance.getApiVersion()); this.withConditions(instance.getConditions()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public A addToConditions( ComponentCondition ...items){
    for (ComponentCondition item : items) {ComponentConditionBuilder builder = new ComponentConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }
    public A removeFromConditions( ComponentCondition ...items){
    for (ComponentCondition item : items) {ComponentConditionBuilder builder = new ComponentConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (A)this;
    }
    public List<ComponentCondition> getConditions(){
    return build(conditions);
    }
    public A withConditions( List<ComponentCondition> conditions){
    this.conditions.clear();if (conditions != null) {for (ComponentCondition item : conditions){this.addToConditions(item);}} return (A) this;
    }
    public A withConditions( ComponentCondition ...conditions){
    this.conditions.clear(); if (conditions != null) {for (ComponentCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }
    public ConditionsNested<A> addNewCondition(){
    return new ConditionsNestedImpl();
    }
    public ConditionsNested<A> addNewConditionLike( ComponentCondition item){
    return new ConditionsNestedImpl(item);
    }
    public A addNewCondition( String error,  String message,  String status,  String type){
    return addToConditions(new ComponentCondition(error, message, status, type));
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ComponentStatusFluentImpl that = (ComponentStatusFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
return true;

    }

    public class ConditionsNestedImpl<N> extends ComponentConditionFluentImpl<ConditionsNested<N>> implements ConditionsNested<N>{

        private final ComponentConditionBuilder builder;
    
             ConditionsNestedImpl (){
        this.builder = new ComponentConditionBuilder(this);
        }
             ConditionsNestedImpl ( ComponentCondition item){
        this.builder = new ComponentConditionBuilder(this, item);
        }
    
            public N endCondition(){
            return and();
        }
            public N and(){
            return (N) ComponentStatusFluentImpl.this.addToConditions(builder.build());
        }
    
}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) ComponentStatusFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
