package io.fabric8.kubernetes.api.model;

import java.util.List;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ContainerFluent<A extends ContainerFluent<A>> extends Fluent<A>{


    public A addToArgs( String ...items);    public A removeFromArgs( String ...items);    public List<String> getArgs();    public A withArgs( List<String> args);    public A withArgs( String ...args);    public A addToCommand( String ...items);    public A removeFromCommand( String ...items);    public List<String> getCommand();    public A withCommand( List<String> command);    public A withCommand( String ...command);    public A addToEnv( EnvVar ...items);    public A removeFromEnv( EnvVar ...items);    public List<EnvVar> getEnv();    public A withEnv( List<EnvVar> env);    public A withEnv( EnvVar ...env);    public EnvNested<A> addNewEnv();    public EnvNested<A> addNewEnvLike( EnvVar item);    public String getImage();    public A withImage( String image);    public String getImagePullPolicy();    public A withImagePullPolicy( String imagePullPolicy);    public Lifecycle getLifecycle();    public A withLifecycle( Lifecycle lifecycle);    public LifecycleNested<A> withNewLifecycle();    public LifecycleNested<A> withNewLifecycleLike( Lifecycle item);    public LifecycleNested<A> editLifecycle();    public Probe getLivenessProbe();    public A withLivenessProbe( Probe livenessProbe);    public LivenessProbeNested<A> withNewLivenessProbe();    public LivenessProbeNested<A> withNewLivenessProbeLike( Probe item);    public LivenessProbeNested<A> editLivenessProbe();    public String getName();    public A withName( String name);    public A addToPorts( ContainerPort ...items);    public A removeFromPorts( ContainerPort ...items);    public List<ContainerPort> getPorts();    public A withPorts( List<ContainerPort> ports);    public A withPorts( ContainerPort ...ports);    public PortsNested<A> addNewPort();    public PortsNested<A> addNewPortLike( ContainerPort item);    public A addNewPort( Integer containerPort,  String hostIP,  Integer hostPort,  String name,  String protocol);    public Probe getReadinessProbe();    public A withReadinessProbe( Probe readinessProbe);    public ReadinessProbeNested<A> withNewReadinessProbe();    public ReadinessProbeNested<A> withNewReadinessProbeLike( Probe item);    public ReadinessProbeNested<A> editReadinessProbe();    public ResourceRequirements getResources();    public A withResources( ResourceRequirements resources);    public ResourcesNested<A> withNewResources();    public ResourcesNested<A> withNewResourcesLike( ResourceRequirements item);    public ResourcesNested<A> editResources();    public SecurityContext getSecurityContext();    public A withSecurityContext( SecurityContext securityContext);    public SecurityContextNested<A> withNewSecurityContext();    public SecurityContextNested<A> withNewSecurityContextLike( SecurityContext item);    public SecurityContextNested<A> editSecurityContext();    public Boolean isStdin();    public A withStdin( Boolean stdin);    public Boolean isStdinOnce();    public A withStdinOnce( Boolean stdinOnce);    public String getTerminationMessagePath();    public A withTerminationMessagePath( String terminationMessagePath);    public Boolean isTty();    public A withTty( Boolean tty);    public A addToVolumeMounts( VolumeMount ...items);    public A removeFromVolumeMounts( VolumeMount ...items);    public List<VolumeMount> getVolumeMounts();    public A withVolumeMounts( List<VolumeMount> volumeMounts);    public A withVolumeMounts( VolumeMount ...volumeMounts);    public VolumeMountsNested<A> addNewVolumeMount();    public VolumeMountsNested<A> addNewVolumeMountLike( VolumeMount item);    public A addNewVolumeMount( String mountPath,  String name,  Boolean readOnly);    public String getWorkingDir();    public A withWorkingDir( String workingDir);
    public interface EnvNested<N> extends Nested<N>,EnvVarFluent<EnvNested<N>>{
            public N endEnv();            public N and();        
}

    public interface LifecycleNested<N> extends Nested<N>,LifecycleFluent<LifecycleNested<N>>{
            public N endLifecycle();            public N and();        
}

    public interface LivenessProbeNested<N> extends Nested<N>,ProbeFluent<LivenessProbeNested<N>>{
            public N endLivenessProbe();            public N and();        
}

    public interface PortsNested<N> extends Nested<N>,ContainerPortFluent<PortsNested<N>>{
            public N endPort();            public N and();        
}

    public interface ReadinessProbeNested<N> extends Nested<N>,ProbeFluent<ReadinessProbeNested<N>>{
            public N endReadinessProbe();            public N and();        
}

    public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<ResourcesNested<N>>{
            public N and();            public N endResources();        
}

    public interface SecurityContextNested<N> extends Nested<N>,SecurityContextFluent<SecurityContextNested<N>>{
            public N and();            public N endSecurityContext();        
}

    public interface VolumeMountsNested<N> extends Nested<N>,VolumeMountFluent<VolumeMountsNested<N>>{
            public N and();            public N endVolumeMount();        
}


}
