package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ContainerStateFluent<A extends ContainerStateFluent<A>> extends Fluent<A>{


    public ContainerStateRunning getRunning();    public A withRunning( ContainerStateRunning running);    public RunningNested<A> withNewRunning();    public RunningNested<A> withNewRunningLike( ContainerStateRunning item);    public RunningNested<A> editRunning();    public A withNewRunning( String startedAt);    public ContainerStateTerminated getTerminated();    public A withTerminated( ContainerStateTerminated terminated);    public TerminatedNested<A> withNewTerminated();    public TerminatedNested<A> withNewTerminatedLike( ContainerStateTerminated item);    public TerminatedNested<A> editTerminated();    public ContainerStateWaiting getWaiting();    public A withWaiting( ContainerStateWaiting waiting);    public WaitingNested<A> withNewWaiting();    public WaitingNested<A> withNewWaitingLike( ContainerStateWaiting item);    public WaitingNested<A> editWaiting();    public A withNewWaiting( String message,  String reason);
    public interface RunningNested<N> extends Nested<N>,ContainerStateRunningFluent<RunningNested<N>>{
            public N and();            public N endRunning();        
}

    public interface TerminatedNested<N> extends Nested<N>,ContainerStateTerminatedFluent<TerminatedNested<N>>{
            public N endTerminated();            public N and();        
}

    public interface WaitingNested<N> extends Nested<N>,ContainerStateWaitingFluent<WaitingNested<N>>{
            public N and();            public N endWaiting();        
}


}
