package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ContainerStateFluentImpl<A extends ContainerStateFluent<A>> extends BaseFluent<A> implements ContainerStateFluent<A>{

     VisitableBuilder<ContainerStateRunning, ?> running;     VisitableBuilder<ContainerStateTerminated, ?> terminated;     VisitableBuilder<ContainerStateWaiting, ?> waiting;
public ContainerStateFluentImpl(){
    
}
public ContainerStateFluentImpl( ContainerState instance ){
    this.withRunning(instance.getRunning()); this.withTerminated(instance.getTerminated()); this.withWaiting(instance.getWaiting()); 
}

    public ContainerStateRunning getRunning(){
    return this.running!=null?this.running.build():null;
    }
    public A withRunning( ContainerStateRunning running){
    if (running!=null){ this.running= new ContainerStateRunningBuilder(running); _visitables.add(this.running);} return (A) this;
    }
    public RunningNested<A> withNewRunning(){
    return new RunningNestedImpl();
    }
    public RunningNested<A> withNewRunningLike( ContainerStateRunning item){
    return new RunningNestedImpl(item);
    }
    public RunningNested<A> editRunning(){
    return withNewRunningLike(getRunning());
    }
    public A withNewRunning( String startedAt){
    return withRunning(new ContainerStateRunning(startedAt));
    }
    public ContainerStateTerminated getTerminated(){
    return this.terminated!=null?this.terminated.build():null;
    }
    public A withTerminated( ContainerStateTerminated terminated){
    if (terminated!=null){ this.terminated= new ContainerStateTerminatedBuilder(terminated); _visitables.add(this.terminated);} return (A) this;
    }
    public TerminatedNested<A> withNewTerminated(){
    return new TerminatedNestedImpl();
    }
    public TerminatedNested<A> withNewTerminatedLike( ContainerStateTerminated item){
    return new TerminatedNestedImpl(item);
    }
    public TerminatedNested<A> editTerminated(){
    return withNewTerminatedLike(getTerminated());
    }
    public ContainerStateWaiting getWaiting(){
    return this.waiting!=null?this.waiting.build():null;
    }
    public A withWaiting( ContainerStateWaiting waiting){
    if (waiting!=null){ this.waiting= new ContainerStateWaitingBuilder(waiting); _visitables.add(this.waiting);} return (A) this;
    }
    public WaitingNested<A> withNewWaiting(){
    return new WaitingNestedImpl();
    }
    public WaitingNested<A> withNewWaitingLike( ContainerStateWaiting item){
    return new WaitingNestedImpl(item);
    }
    public WaitingNested<A> editWaiting(){
    return withNewWaitingLike(getWaiting());
    }
    public A withNewWaiting( String message,  String reason){
    return withWaiting(new ContainerStateWaiting(message, reason));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerStateFluentImpl that = (ContainerStateFluentImpl) o;
if (running != null ? !running.equals(that.running) :that.running != null) return false;
if (terminated != null ? !terminated.equals(that.terminated) :that.terminated != null) return false;
if (waiting != null ? !waiting.equals(that.waiting) :that.waiting != null) return false;
return true;

    }

    public class RunningNestedImpl<N> extends ContainerStateRunningFluentImpl<RunningNested<N>> implements RunningNested<N>{

        private final ContainerStateRunningBuilder builder;
    
             RunningNestedImpl (){
        this.builder = new ContainerStateRunningBuilder(this);
        }
             RunningNestedImpl ( ContainerStateRunning item){
        this.builder = new ContainerStateRunningBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerStateFluentImpl.this.withRunning(builder.build());
        }
            public N endRunning(){
            return and();
        }
    
}
    public class TerminatedNestedImpl<N> extends ContainerStateTerminatedFluentImpl<TerminatedNested<N>> implements TerminatedNested<N>{

        private final ContainerStateTerminatedBuilder builder;
    
             TerminatedNestedImpl ( ContainerStateTerminated item){
        this.builder = new ContainerStateTerminatedBuilder(this, item);
        }
             TerminatedNestedImpl (){
        this.builder = new ContainerStateTerminatedBuilder(this);
        }
    
            public N endTerminated(){
            return and();
        }
            public N and(){
            return (N) ContainerStateFluentImpl.this.withTerminated(builder.build());
        }
    
}
    public class WaitingNestedImpl<N> extends ContainerStateWaitingFluentImpl<WaitingNested<N>> implements WaitingNested<N>{

        private final ContainerStateWaitingBuilder builder;
    
             WaitingNestedImpl (){
        this.builder = new ContainerStateWaitingBuilder(this);
        }
             WaitingNestedImpl ( ContainerStateWaiting item){
        this.builder = new ContainerStateWaitingBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerStateFluentImpl.this.withWaiting(builder.build());
        }
            public N endWaiting(){
            return and();
        }
    
}


}
