package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ContainerStatusFluent<A extends ContainerStatusFluent<A>> extends Fluent<A>{


    public String getContainerID();    public A withContainerID( String containerID);    public String getImage();    public A withImage( String image);    public String getImageID();    public A withImageID( String imageID);    public ContainerState getLastState();    public A withLastState( ContainerState lastState);    public LastStateNested<A> withNewLastState();    public LastStateNested<A> withNewLastStateLike( ContainerState item);    public LastStateNested<A> editLastState();    public String getName();    public A withName( String name);    public Boolean isReady();    public A withReady( Boolean ready);    public Integer getRestartCount();    public A withRestartCount( Integer restartCount);    public ContainerState getState();    public A withState( ContainerState state);    public StateNested<A> withNewState();    public StateNested<A> withNewStateLike( ContainerState item);    public StateNested<A> editState();
    public interface LastStateNested<N> extends Nested<N>,ContainerStateFluent<LastStateNested<N>>{
            public N endLastState();            public N and();        
}

    public interface StateNested<N> extends Nested<N>,ContainerStateFluent<StateNested<N>>{
            public N and();            public N endState();        
}


}
