package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class ContainerStatusFluentImpl<A extends ContainerStatusFluent<A>> extends BaseFluent<A> implements ContainerStatusFluent<A>{

     String containerID;     String image;     String imageID;     VisitableBuilder<ContainerState, ?> lastState;     String name;     Boolean ready;     Integer restartCount;     VisitableBuilder<ContainerState, ?> state;
public ContainerStatusFluentImpl(){
    
}
public ContainerStatusFluentImpl( ContainerStatus instance ){
    this.withContainerID(instance.getContainerID()); this.withImage(instance.getImage()); this.withImageID(instance.getImageID()); this.withLastState(instance.getLastState()); this.withName(instance.getName()); this.withReady(instance.getReady()); this.withRestartCount(instance.getRestartCount()); this.withState(instance.getState()); 
}

    public String getContainerID(){
    return this.containerID;
    }
    public A withContainerID( String containerID){
    this.containerID=containerID; return (A) this;
    }
    public String getImage(){
    return this.image;
    }
    public A withImage( String image){
    this.image=image; return (A) this;
    }
    public String getImageID(){
    return this.imageID;
    }
    public A withImageID( String imageID){
    this.imageID=imageID; return (A) this;
    }
    public ContainerState getLastState(){
    return this.lastState!=null?this.lastState.build():null;
    }
    public A withLastState( ContainerState lastState){
    if (lastState!=null){ this.lastState= new ContainerStateBuilder(lastState); _visitables.add(this.lastState);} return (A) this;
    }
    public LastStateNested<A> withNewLastState(){
    return new LastStateNestedImpl();
    }
    public LastStateNested<A> withNewLastStateLike( ContainerState item){
    return new LastStateNestedImpl(item);
    }
    public LastStateNested<A> editLastState(){
    return withNewLastStateLike(getLastState());
    }
    public String getName(){
    return this.name;
    }
    public A withName( String name){
    this.name=name; return (A) this;
    }
    public Boolean isReady(){
    return this.ready;
    }
    public A withReady( Boolean ready){
    this.ready=ready; return (A) this;
    }
    public Integer getRestartCount(){
    return this.restartCount;
    }
    public A withRestartCount( Integer restartCount){
    this.restartCount=restartCount; return (A) this;
    }
    public ContainerState getState(){
    return this.state!=null?this.state.build():null;
    }
    public A withState( ContainerState state){
    if (state!=null){ this.state= new ContainerStateBuilder(state); _visitables.add(this.state);} return (A) this;
    }
    public StateNested<A> withNewState(){
    return new StateNestedImpl();
    }
    public StateNested<A> withNewStateLike( ContainerState item){
    return new StateNestedImpl(item);
    }
    public StateNested<A> editState(){
    return withNewStateLike(getState());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerStatusFluentImpl that = (ContainerStatusFluentImpl) o;
if (containerID != null ? !containerID.equals(that.containerID) :that.containerID != null) return false;
if (image != null ? !image.equals(that.image) :that.image != null) return false;
if (imageID != null ? !imageID.equals(that.imageID) :that.imageID != null) return false;
if (lastState != null ? !lastState.equals(that.lastState) :that.lastState != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (ready != null ? !ready.equals(that.ready) :that.ready != null) return false;
if (restartCount != null ? !restartCount.equals(that.restartCount) :that.restartCount != null) return false;
if (state != null ? !state.equals(that.state) :that.state != null) return false;
return true;

    }

    public class LastStateNestedImpl<N> extends ContainerStateFluentImpl<LastStateNested<N>> implements LastStateNested<N>{

        private final ContainerStateBuilder builder;
    
             LastStateNestedImpl (){
        this.builder = new ContainerStateBuilder(this);
        }
             LastStateNestedImpl ( ContainerState item){
        this.builder = new ContainerStateBuilder(this, item);
        }
    
            public N endLastState(){
            return and();
        }
            public N and(){
            return (N) ContainerStatusFluentImpl.this.withLastState(builder.build());
        }
    
}
    public class StateNestedImpl<N> extends ContainerStateFluentImpl<StateNested<N>> implements StateNested<N>{

        private final ContainerStateBuilder builder;
    
             StateNestedImpl (){
        this.builder = new ContainerStateBuilder(this);
        }
             StateNestedImpl ( ContainerState item){
        this.builder = new ContainerStateBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerStatusFluentImpl.this.withState(builder.build());
        }
            public N endState(){
            return and();
        }
    
}


}
