package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class DeleteOptionsBuilder extends DeleteOptionsFluentImpl<DeleteOptionsBuilder> implements VisitableBuilder<DeleteOptions,DeleteOptionsBuilder>{

     DeleteOptionsFluent<?> fluent;
public DeleteOptionsBuilder(){
    this(new DeleteOptions());
}
public DeleteOptionsBuilder( DeleteOptionsFluent<?> fluent ){
    this(fluent, new DeleteOptions());
}
public DeleteOptionsBuilder( DeleteOptionsFluent<?> fluent , DeleteOptions instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withGracePeriodSeconds(instance.getGracePeriodSeconds()); fluent.withKind(instance.getKind()); fluent.withPreconditions(instance.getPreconditions()); 
}
public DeleteOptionsBuilder( DeleteOptions instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withGracePeriodSeconds(instance.getGracePeriodSeconds()); this.withKind(instance.getKind()); this.withPreconditions(instance.getPreconditions()); 
}

public DeleteOptions build(){
    DeleteOptions buildable = new DeleteOptions(fluent.getApiVersion(),fluent.getGracePeriodSeconds(),fluent.getKind(),fluent.getPreconditions());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DeleteOptionsBuilder that = (DeleteOptionsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
