package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class DownwardAPIVolumeFileBuilder extends DownwardAPIVolumeFileFluentImpl<DownwardAPIVolumeFileBuilder> implements VisitableBuilder<DownwardAPIVolumeFile,DownwardAPIVolumeFileBuilder>{

     DownwardAPIVolumeFileFluent<?> fluent;
public DownwardAPIVolumeFileBuilder(){
    this(new DownwardAPIVolumeFile());
}
public DownwardAPIVolumeFileBuilder( DownwardAPIVolumeFileFluent<?> fluent ){
    this(fluent, new DownwardAPIVolumeFile());
}
public DownwardAPIVolumeFileBuilder( DownwardAPIVolumeFileFluent<?> fluent , DownwardAPIVolumeFile instance ){
    this.fluent = fluent; fluent.withFieldRef(instance.getFieldRef()); fluent.withPath(instance.getPath()); 
}
public DownwardAPIVolumeFileBuilder( DownwardAPIVolumeFile instance ){
    this.fluent = this; this.withFieldRef(instance.getFieldRef()); this.withPath(instance.getPath()); 
}

public DownwardAPIVolumeFile build(){
    DownwardAPIVolumeFile buildable = new DownwardAPIVolumeFile(fluent.getFieldRef(),fluent.getPath());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DownwardAPIVolumeFileBuilder that = (DownwardAPIVolumeFileBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
