package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class EndpointAddressFluentImpl<A extends EndpointAddressFluent<A>> extends BaseFluent<A> implements EndpointAddressFluent<A>{

     String ip;     VisitableBuilder<ObjectReference, ?> targetRef;
public EndpointAddressFluentImpl(){
    
}
public EndpointAddressFluentImpl( EndpointAddress instance ){
    this.withIp(instance.getIp()); this.withTargetRef(instance.getTargetRef()); 
}

    public String getIp(){
    return this.ip;
    }
    public A withIp( String ip){
    this.ip=ip; return (A) this;
    }
    public ObjectReference getTargetRef(){
    return this.targetRef!=null?this.targetRef.build():null;
    }
    public A withTargetRef( ObjectReference targetRef){
    if (targetRef!=null){ this.targetRef= new ObjectReferenceBuilder(targetRef); _visitables.add(this.targetRef);} return (A) this;
    }
    public TargetRefNested<A> withNewTargetRef(){
    return new TargetRefNestedImpl();
    }
    public TargetRefNested<A> withNewTargetRefLike( ObjectReference item){
    return new TargetRefNestedImpl(item);
    }
    public TargetRefNested<A> editTargetRef(){
    return withNewTargetRefLike(getTargetRef());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EndpointAddressFluentImpl that = (EndpointAddressFluentImpl) o;
if (ip != null ? !ip.equals(that.ip) :that.ip != null) return false;
if (targetRef != null ? !targetRef.equals(that.targetRef) :that.targetRef != null) return false;
return true;

    }

    public class TargetRefNestedImpl<N> extends ObjectReferenceFluentImpl<TargetRefNested<N>> implements TargetRefNested<N>{

        private final ObjectReferenceBuilder builder;
    
             TargetRefNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             TargetRefNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N endTargetRef(){
            return and();
        }
            public N and(){
            return (N) EndpointAddressFluentImpl.this.withTargetRef(builder.build());
        }
    
}


}
