package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface EndpointSubsetFluent<A extends EndpointSubsetFluent<A>> extends Fluent<A>{


    public A addToAddresses( EndpointAddress ...items);    public A removeFromAddresses( EndpointAddress ...items);    public List<EndpointAddress> getAddresses();    public A withAddresses( List<EndpointAddress> addresses);    public A withAddresses( EndpointAddress ...addresses);    public AddressesNested<A> addNewAddresse();    public AddressesNested<A> addNewAddresseLike( EndpointAddress item);    public A addToNotReadyAddresses( EndpointAddress ...items);    public A removeFromNotReadyAddresses( EndpointAddress ...items);    public List<EndpointAddress> getNotReadyAddresses();    public A withNotReadyAddresses( List<EndpointAddress> notReadyAddresses);    public A withNotReadyAddresses( EndpointAddress ...notReadyAddresses);    public NotReadyAddressesNested<A> addNewNotReadyAddresse();    public NotReadyAddressesNested<A> addNewNotReadyAddresseLike( EndpointAddress item);    public A addToPorts( EndpointPort ...items);    public A removeFromPorts( EndpointPort ...items);    public List<EndpointPort> getPorts();    public A withPorts( List<EndpointPort> ports);    public A withPorts( EndpointPort ...ports);    public PortsNested<A> addNewPort();    public PortsNested<A> addNewPortLike( EndpointPort item);    public A addNewPort( String name,  Integer port,  String protocol);
    public interface AddressesNested<N> extends Nested<N>,EndpointAddressFluent<AddressesNested<N>>{
            public N and();            public N endAddresse();        
}

    public interface NotReadyAddressesNested<N> extends Nested<N>,EndpointAddressFluent<NotReadyAddressesNested<N>>{
            public N endNotReadyAddresse();            public N and();        
}

    public interface PortsNested<N> extends Nested<N>,EndpointPortFluent<PortsNested<N>>{
            public N endPort();            public N and();        
}


}
