package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class EnvVarFluentImpl<A extends EnvVarFluent<A>> extends BaseFluent<A> implements EnvVarFluent<A>{

     String name;     String value;     VisitableBuilder<EnvVarSource, ?> valueFrom;
public EnvVarFluentImpl(){
    
}
public EnvVarFluentImpl( EnvVar instance ){
    this.withName(instance.getName()); this.withValue(instance.getValue()); this.withValueFrom(instance.getValueFrom()); 
}

    public String getName(){
    return this.name;
    }
    public A withName( String name){
    this.name=name; return (A) this;
    }
    public String getValue(){
    return this.value;
    }
    public A withValue( String value){
    this.value=value; return (A) this;
    }
    public EnvVarSource getValueFrom(){
    return this.valueFrom!=null?this.valueFrom.build():null;
    }
    public A withValueFrom( EnvVarSource valueFrom){
    if (valueFrom!=null){ this.valueFrom= new EnvVarSourceBuilder(valueFrom); _visitables.add(this.valueFrom);} return (A) this;
    }
    public ValueFromNested<A> withNewValueFrom(){
    return new ValueFromNestedImpl();
    }
    public ValueFromNested<A> withNewValueFromLike( EnvVarSource item){
    return new ValueFromNestedImpl(item);
    }
    public ValueFromNested<A> editValueFrom(){
    return withNewValueFromLike(getValueFrom());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EnvVarFluentImpl that = (EnvVarFluentImpl) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (value != null ? !value.equals(that.value) :that.value != null) return false;
if (valueFrom != null ? !valueFrom.equals(that.valueFrom) :that.valueFrom != null) return false;
return true;

    }

    public class ValueFromNestedImpl<N> extends EnvVarSourceFluentImpl<ValueFromNested<N>> implements ValueFromNested<N>{

        private final EnvVarSourceBuilder builder;
    
             ValueFromNestedImpl (){
        this.builder = new EnvVarSourceBuilder(this);
        }
             ValueFromNestedImpl ( EnvVarSource item){
        this.builder = new EnvVarSourceBuilder(this, item);
        }
    
            public N endValueFrom(){
            return and();
        }
            public N and(){
            return (N) EnvVarFluentImpl.this.withValueFrom(builder.build());
        }
    
}


}
