package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class FlexVolumeSourceBuilder extends FlexVolumeSourceFluentImpl<FlexVolumeSourceBuilder> implements VisitableBuilder<FlexVolumeSource,FlexVolumeSourceBuilder>{

     FlexVolumeSourceFluent<?> fluent;
public FlexVolumeSourceBuilder(){
    this(new FlexVolumeSource());
}
public FlexVolumeSourceBuilder( FlexVolumeSourceFluent<?> fluent ){
    this(fluent, new FlexVolumeSource());
}
public FlexVolumeSourceBuilder( FlexVolumeSourceFluent<?> fluent , FlexVolumeSource instance ){
    this.fluent = fluent; fluent.withDriver(instance.getDriver()); fluent.withFsType(instance.getFsType()); fluent.withOptions(instance.getOptions()); fluent.withReadOnly(instance.getReadOnly()); fluent.withSecretRef(instance.getSecretRef()); 
}
public FlexVolumeSourceBuilder( FlexVolumeSource instance ){
    this.fluent = this; this.withDriver(instance.getDriver()); this.withFsType(instance.getFsType()); this.withOptions(instance.getOptions()); this.withReadOnly(instance.getReadOnly()); this.withSecretRef(instance.getSecretRef()); 
}

public FlexVolumeSource build(){
    FlexVolumeSource buildable = new FlexVolumeSource(fluent.getDriver(),fluent.getFsType(),fluent.getOptions(),fluent.isReadOnly(),fluent.getSecretRef());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
FlexVolumeSourceBuilder that = (FlexVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
