package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class GlusterfsVolumeSourceFluentImpl<A extends GlusterfsVolumeSourceFluent<A>> extends BaseFluent<A> implements GlusterfsVolumeSourceFluent<A>{

     String endpoints;     String path;     Boolean readOnly;
public GlusterfsVolumeSourceFluentImpl(){
    
}
public GlusterfsVolumeSourceFluentImpl( GlusterfsVolumeSource instance ){
    this.withEndpoints(instance.getEndpoints()); this.withPath(instance.getPath()); this.withReadOnly(instance.getReadOnly()); 
}

    public String getEndpoints(){
    return this.endpoints;
    }
    public A withEndpoints( String endpoints){
    this.endpoints=endpoints; return (A) this;
    }
    public String getPath(){
    return this.path;
    }
    public A withPath( String path){
    this.path=path; return (A) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public A withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
GlusterfsVolumeSourceFluentImpl that = (GlusterfsVolumeSourceFluentImpl) o;
if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
if (path != null ? !path.equals(that.path) :that.path != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
return true;

    }



}
