package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import java.util.List;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;

public class HTTPGetActionFluentImpl<A extends HTTPGetActionFluent<A>> extends BaseFluent<A> implements HTTPGetActionFluent<A>{

     String host;     List<VisitableBuilder<HTTPHeader, ?>> httpHeaders = new ArrayList();     String path;     VisitableBuilder<IntOrString, ?> port;     String scheme;
public HTTPGetActionFluentImpl(){
    
}
public HTTPGetActionFluentImpl( HTTPGetAction instance ){
    this.withHost(instance.getHost()); this.withHttpHeaders(instance.getHttpHeaders()); this.withPath(instance.getPath()); this.withPort(instance.getPort()); this.withScheme(instance.getScheme()); 
}

    public String getHost(){
    return this.host;
    }
    public A withHost( String host){
    this.host=host; return (A) this;
    }
    public A addToHttpHeaders( HTTPHeader ...items){
    for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.add(builder);this.httpHeaders.add(builder);} return (A)this;
    }
    public A removeFromHttpHeaders( HTTPHeader ...items){
    for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.remove(builder);this.httpHeaders.remove(builder);} return (A)this;
    }
    public List<HTTPHeader> getHttpHeaders(){
    return build(httpHeaders);
    }
    public A withHttpHeaders( List<HTTPHeader> httpHeaders){
    this.httpHeaders.clear();if (httpHeaders != null) {for (HTTPHeader item : httpHeaders){this.addToHttpHeaders(item);}} return (A) this;
    }
    public A withHttpHeaders( HTTPHeader ...httpHeaders){
    this.httpHeaders.clear(); if (httpHeaders != null) {for (HTTPHeader item :httpHeaders){ this.addToHttpHeaders(item);}} return (A) this;
    }
    public HttpHeadersNested<A> addNewHttpHeader(){
    return new HttpHeadersNestedImpl();
    }
    public HttpHeadersNested<A> addNewHttpHeaderLike( HTTPHeader item){
    return new HttpHeadersNestedImpl(item);
    }
    public A addNewHttpHeader( String name,  String value){
    return addToHttpHeaders(new HTTPHeader(name, value));
    }
    public String getPath(){
    return this.path;
    }
    public A withPath( String path){
    this.path=path; return (A) this;
    }
    public IntOrString getPort(){
    return this.port!=null?this.port.build():null;
    }
    public A withPort( IntOrString port){
    if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.add(this.port);} return (A) this;
    }
    public PortNested<A> withNewPort(){
    return new PortNestedImpl();
    }
    public PortNested<A> withNewPortLike( IntOrString item){
    return new PortNestedImpl(item);
    }
    public PortNested<A> editPort(){
    return withNewPortLike(getPort());
    }
    public A withNewPort( String strVal){
    return withPort(new IntOrString(strVal));
    }
    public A withNewPort( Integer intVal){
    return withPort(new IntOrString(intVal));
    }
    public String getScheme(){
    return this.scheme;
    }
    public A withScheme( String scheme){
    this.scheme=scheme; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HTTPGetActionFluentImpl that = (HTTPGetActionFluentImpl) o;
if (host != null ? !host.equals(that.host) :that.host != null) return false;
if (httpHeaders != null ? !httpHeaders.equals(that.httpHeaders) :that.httpHeaders != null) return false;
if (path != null ? !path.equals(that.path) :that.path != null) return false;
if (port != null ? !port.equals(that.port) :that.port != null) return false;
if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
return true;

    }

    public class HttpHeadersNestedImpl<N> extends HTTPHeaderFluentImpl<HttpHeadersNested<N>> implements HttpHeadersNested<N>{

        private final HTTPHeaderBuilder builder;
    
             HttpHeadersNestedImpl (){
        this.builder = new HTTPHeaderBuilder(this);
        }
             HttpHeadersNestedImpl ( HTTPHeader item){
        this.builder = new HTTPHeaderBuilder(this, item);
        }
    
            public N endHttpHeader(){
            return and();
        }
            public N and(){
            return (N) HTTPGetActionFluentImpl.this.addToHttpHeaders(builder.build());
        }
    
}
    public class PortNestedImpl<N> extends IntOrStringFluentImpl<PortNested<N>> implements PortNested<N>{

        private final IntOrStringBuilder builder;
    
             PortNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             PortNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N endPort(){
            return and();
        }
            public N and(){
            return (N) HTTPGetActionFluentImpl.this.withPort(builder.build());
        }
    
}


}
