package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class HandlerFluentImpl<A extends HandlerFluent<A>> extends BaseFluent<A> implements HandlerFluent<A>{

     VisitableBuilder<ExecAction, ?> exec;     VisitableBuilder<HTTPGetAction, ?> httpGet;     VisitableBuilder<TCPSocketAction, ?> tcpSocket;
public HandlerFluentImpl(){
    
}
public HandlerFluentImpl( Handler instance ){
    this.withExec(instance.getExec()); this.withHttpGet(instance.getHttpGet()); this.withTcpSocket(instance.getTcpSocket()); 
}

    public ExecAction getExec(){
    return this.exec!=null?this.exec.build():null;
    }
    public A withExec( ExecAction exec){
    if (exec!=null){ this.exec= new ExecActionBuilder(exec); _visitables.add(this.exec);} return (A) this;
    }
    public ExecNested<A> withNewExec(){
    return new ExecNestedImpl();
    }
    public ExecNested<A> withNewExecLike( ExecAction item){
    return new ExecNestedImpl(item);
    }
    public ExecNested<A> editExec(){
    return withNewExecLike(getExec());
    }
    public HTTPGetAction getHttpGet(){
    return this.httpGet!=null?this.httpGet.build():null;
    }
    public A withHttpGet( HTTPGetAction httpGet){
    if (httpGet!=null){ this.httpGet= new HTTPGetActionBuilder(httpGet); _visitables.add(this.httpGet);} return (A) this;
    }
    public HttpGetNested<A> withNewHttpGet(){
    return new HttpGetNestedImpl();
    }
    public HttpGetNested<A> withNewHttpGetLike( HTTPGetAction item){
    return new HttpGetNestedImpl(item);
    }
    public HttpGetNested<A> editHttpGet(){
    return withNewHttpGetLike(getHttpGet());
    }
    public TCPSocketAction getTcpSocket(){
    return this.tcpSocket!=null?this.tcpSocket.build():null;
    }
    public A withTcpSocket( TCPSocketAction tcpSocket){
    if (tcpSocket!=null){ this.tcpSocket= new TCPSocketActionBuilder(tcpSocket); _visitables.add(this.tcpSocket);} return (A) this;
    }
    public TcpSocketNested<A> withNewTcpSocket(){
    return new TcpSocketNestedImpl();
    }
    public TcpSocketNested<A> withNewTcpSocketLike( TCPSocketAction item){
    return new TcpSocketNestedImpl(item);
    }
    public TcpSocketNested<A> editTcpSocket(){
    return withNewTcpSocketLike(getTcpSocket());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HandlerFluentImpl that = (HandlerFluentImpl) o;
if (exec != null ? !exec.equals(that.exec) :that.exec != null) return false;
if (httpGet != null ? !httpGet.equals(that.httpGet) :that.httpGet != null) return false;
if (tcpSocket != null ? !tcpSocket.equals(that.tcpSocket) :that.tcpSocket != null) return false;
return true;

    }

    public class ExecNestedImpl<N> extends ExecActionFluentImpl<ExecNested<N>> implements ExecNested<N>{

        private final ExecActionBuilder builder;
    
             ExecNestedImpl (){
        this.builder = new ExecActionBuilder(this);
        }
             ExecNestedImpl ( ExecAction item){
        this.builder = new ExecActionBuilder(this, item);
        }
    
            public N and(){
            return (N) HandlerFluentImpl.this.withExec(builder.build());
        }
            public N endExec(){
            return and();
        }
    
}
    public class HttpGetNestedImpl<N> extends HTTPGetActionFluentImpl<HttpGetNested<N>> implements HttpGetNested<N>{

        private final HTTPGetActionBuilder builder;
    
             HttpGetNestedImpl (){
        this.builder = new HTTPGetActionBuilder(this);
        }
             HttpGetNestedImpl ( HTTPGetAction item){
        this.builder = new HTTPGetActionBuilder(this, item);
        }
    
            public N endHttpGet(){
            return and();
        }
            public N and(){
            return (N) HandlerFluentImpl.this.withHttpGet(builder.build());
        }
    
}
    public class TcpSocketNestedImpl<N> extends TCPSocketActionFluentImpl<TcpSocketNested<N>> implements TcpSocketNested<N>{

        private final TCPSocketActionBuilder builder;
    
             TcpSocketNestedImpl (){
        this.builder = new TCPSocketActionBuilder(this);
        }
             TcpSocketNestedImpl ( TCPSocketAction item){
        this.builder = new TCPSocketActionBuilder(this, item);
        }
    
            public N and(){
            return (N) HandlerFluentImpl.this.withTcpSocket(builder.build());
        }
            public N endTcpSocket(){
            return and();
        }
    
}


}
