package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ISCSIVolumeSourceFluentImpl<A extends ISCSIVolumeSourceFluent<A>> extends BaseFluent<A> implements ISCSIVolumeSourceFluent<A>{

     String fsType;     String iqn;     String iscsiInterface;     Integer lun;     Boolean readOnly;     String targetPortal;
public ISCSIVolumeSourceFluentImpl(){
    
}
public ISCSIVolumeSourceFluentImpl( ISCSIVolumeSource instance ){
    this.withFsType(instance.getFsType()); this.withIqn(instance.getIqn()); this.withIscsiInterface(instance.getIscsiInterface()); this.withLun(instance.getLun()); this.withReadOnly(instance.getReadOnly()); this.withTargetPortal(instance.getTargetPortal()); 
}

    public String getFsType(){
    return this.fsType;
    }
    public A withFsType( String fsType){
    this.fsType=fsType; return (A) this;
    }
    public String getIqn(){
    return this.iqn;
    }
    public A withIqn( String iqn){
    this.iqn=iqn; return (A) this;
    }
    public String getIscsiInterface(){
    return this.iscsiInterface;
    }
    public A withIscsiInterface( String iscsiInterface){
    this.iscsiInterface=iscsiInterface; return (A) this;
    }
    public Integer getLun(){
    return this.lun;
    }
    public A withLun( Integer lun){
    this.lun=lun; return (A) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public A withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (A) this;
    }
    public String getTargetPortal(){
    return this.targetPortal;
    }
    public A withTargetPortal( String targetPortal){
    this.targetPortal=targetPortal; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ISCSIVolumeSourceFluentImpl that = (ISCSIVolumeSourceFluentImpl) o;
if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
if (iqn != null ? !iqn.equals(that.iqn) :that.iqn != null) return false;
if (iscsiInterface != null ? !iscsiInterface.equals(that.iscsiInterface) :that.iscsiInterface != null) return false;
if (lun != null ? !lun.equals(that.lun) :that.lun != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (targetPortal != null ? !targetPortal.equals(that.targetPortal) :that.targetPortal != null) return false;
return true;

    }



}
