package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class KeyToPathBuilder extends KeyToPathFluentImpl<KeyToPathBuilder> implements VisitableBuilder<KeyToPath,KeyToPathBuilder>{

     KeyToPathFluent<?> fluent;
public KeyToPathBuilder(){
    this(new KeyToPath());
}
public KeyToPathBuilder( KeyToPathFluent<?> fluent ){
    this(fluent, new KeyToPath());
}
public KeyToPathBuilder( KeyToPathFluent<?> fluent , KeyToPath instance ){
    this.fluent = fluent; fluent.withKey(instance.getKey()); fluent.withPath(instance.getPath()); 
}
public KeyToPathBuilder( KeyToPath instance ){
    this.fluent = this; this.withKey(instance.getKey()); this.withPath(instance.getPath()); 
}

public KeyToPath build(){
    KeyToPath buildable = new KeyToPath(fluent.getKey(),fluent.getPath());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
KeyToPathBuilder that = (KeyToPathBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
