package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class LifecycleFluentImpl<A extends LifecycleFluent<A>> extends BaseFluent<A> implements LifecycleFluent<A>{

     VisitableBuilder<Handler, ?> postStart;     VisitableBuilder<Handler, ?> preStop;
public LifecycleFluentImpl(){
    
}
public LifecycleFluentImpl( Lifecycle instance ){
    this.withPostStart(instance.getPostStart()); this.withPreStop(instance.getPreStop()); 
}

    public Handler getPostStart(){
    return this.postStart!=null?this.postStart.build():null;
    }
    public A withPostStart( Handler postStart){
    if (postStart!=null){ this.postStart= new HandlerBuilder(postStart); _visitables.add(this.postStart);} return (A) this;
    }
    public PostStartNested<A> withNewPostStart(){
    return new PostStartNestedImpl();
    }
    public PostStartNested<A> withNewPostStartLike( Handler item){
    return new PostStartNestedImpl(item);
    }
    public PostStartNested<A> editPostStart(){
    return withNewPostStartLike(getPostStart());
    }
    public Handler getPreStop(){
    return this.preStop!=null?this.preStop.build():null;
    }
    public A withPreStop( Handler preStop){
    if (preStop!=null){ this.preStop= new HandlerBuilder(preStop); _visitables.add(this.preStop);} return (A) this;
    }
    public PreStopNested<A> withNewPreStop(){
    return new PreStopNestedImpl();
    }
    public PreStopNested<A> withNewPreStopLike( Handler item){
    return new PreStopNestedImpl(item);
    }
    public PreStopNested<A> editPreStop(){
    return withNewPreStopLike(getPreStop());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
LifecycleFluentImpl that = (LifecycleFluentImpl) o;
if (postStart != null ? !postStart.equals(that.postStart) :that.postStart != null) return false;
if (preStop != null ? !preStop.equals(that.preStop) :that.preStop != null) return false;
return true;

    }

    public class PostStartNestedImpl<N> extends HandlerFluentImpl<PostStartNested<N>> implements PostStartNested<N>{

        private final HandlerBuilder builder;
    
             PostStartNestedImpl (){
        this.builder = new HandlerBuilder(this);
        }
             PostStartNestedImpl ( Handler item){
        this.builder = new HandlerBuilder(this, item);
        }
    
            public N endPostStart(){
            return and();
        }
            public N and(){
            return (N) LifecycleFluentImpl.this.withPostStart(builder.build());
        }
    
}
    public class PreStopNestedImpl<N> extends HandlerFluentImpl<PreStopNested<N>> implements PreStopNested<N>{

        private final HandlerBuilder builder;
    
             PreStopNestedImpl (){
        this.builder = new HandlerBuilder(this);
        }
             PreStopNestedImpl ( Handler item){
        this.builder = new HandlerBuilder(this, item);
        }
    
            public N and(){
            return (N) LifecycleFluentImpl.this.withPreStop(builder.build());
        }
            public N endPreStop(){
            return and();
        }
    
}


}
