package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class LimitRangeBuilder extends LimitRangeFluentImpl<LimitRangeBuilder> implements VisitableBuilder<LimitRange,LimitRangeBuilder>{

     LimitRangeFluent<?> fluent;
public LimitRangeBuilder(){
    this(new LimitRange());
}
public LimitRangeBuilder( LimitRangeFluent<?> fluent ){
    this(fluent, new LimitRange());
}
public LimitRangeBuilder( LimitRangeFluent<?> fluent , LimitRange instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withSpec(instance.getSpec()); 
}
public LimitRangeBuilder( LimitRange instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withSpec(instance.getSpec()); 
}

public LimitRange build(){
    LimitRange buildable = new LimitRange(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
LimitRangeBuilder that = (LimitRangeBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
