package io.fabric8.kubernetes.api.model;

import java.util.List;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class LimitRangeSpecFluentImpl<A extends LimitRangeSpecFluent<A>> extends BaseFluent<A> implements LimitRangeSpecFluent<A>{

     List<VisitableBuilder<LimitRangeItem, ?>> limits = new ArrayList();
public LimitRangeSpecFluentImpl(){
    
}
public LimitRangeSpecFluentImpl( LimitRangeSpec instance ){
    this.withLimits(instance.getLimits()); 
}

    public A addToLimits( LimitRangeItem ...items){
    for (LimitRangeItem item : items) {LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);_visitables.add(builder);this.limits.add(builder);} return (A)this;
    }
    public A removeFromLimits( LimitRangeItem ...items){
    for (LimitRangeItem item : items) {LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);_visitables.remove(builder);this.limits.remove(builder);} return (A)this;
    }
    public List<LimitRangeItem> getLimits(){
    return build(limits);
    }
    public A withLimits( List<LimitRangeItem> limits){
    this.limits.clear();if (limits != null) {for (LimitRangeItem item : limits){this.addToLimits(item);}} return (A) this;
    }
    public A withLimits( LimitRangeItem ...limits){
    this.limits.clear(); if (limits != null) {for (LimitRangeItem item :limits){ this.addToLimits(item);}} return (A) this;
    }
    public LimitsNested<A> addNewLimit(){
    return new LimitsNestedImpl();
    }
    public LimitsNested<A> addNewLimitLike( LimitRangeItem item){
    return new LimitsNestedImpl(item);
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
LimitRangeSpecFluentImpl that = (LimitRangeSpecFluentImpl) o;
if (limits != null ? !limits.equals(that.limits) :that.limits != null) return false;
return true;

    }

    public class LimitsNestedImpl<N> extends LimitRangeItemFluentImpl<LimitsNested<N>> implements LimitsNested<N>{

        private final LimitRangeItemBuilder builder;
    
             LimitsNestedImpl (){
        this.builder = new LimitRangeItemBuilder(this);
        }
             LimitsNestedImpl ( LimitRangeItem item){
        this.builder = new LimitRangeItemBuilder(this, item);
        }
    
            public N and(){
            return (N) LimitRangeSpecFluentImpl.this.addToLimits(builder.build());
        }
            public N endLimit(){
            return and();
        }
    
}


}
