package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ListMetaFluentImpl<A extends ListMetaFluent<A>> extends BaseFluent<A> implements ListMetaFluent<A>{

     String resourceVersion;     String selfLink;
public ListMetaFluentImpl(){
    
}
public ListMetaFluentImpl( ListMeta instance ){
    this.withResourceVersion(instance.getResourceVersion()); this.withSelfLink(instance.getSelfLink()); 
}

    public String getResourceVersion(){
    return this.resourceVersion;
    }
    public A withResourceVersion( String resourceVersion){
    this.resourceVersion=resourceVersion; return (A) this;
    }
    public String getSelfLink(){
    return this.selfLink;
    }
    public A withSelfLink( String selfLink){
    this.selfLink=selfLink; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ListMetaFluentImpl that = (ListMetaFluentImpl) o;
if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
if (selfLink != null ? !selfLink.equals(that.selfLink) :that.selfLink != null) return false;
return true;

    }



}
