package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class LoadBalancerStatusFluentImpl<A extends LoadBalancerStatusFluent<A>> extends BaseFluent<A> implements LoadBalancerStatusFluent<A>{

     List<VisitableBuilder<LoadBalancerIngress, ?>> ingress = new ArrayList();
public LoadBalancerStatusFluentImpl(){
    
}
public LoadBalancerStatusFluentImpl( LoadBalancerStatus instance ){
    this.withIngress(instance.getIngress()); 
}

    public A addToIngress( LoadBalancerIngress ...items){
    for (LoadBalancerIngress item : items) {LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);_visitables.add(builder);this.ingress.add(builder);} return (A)this;
    }
    public A removeFromIngress( LoadBalancerIngress ...items){
    for (LoadBalancerIngress item : items) {LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);_visitables.remove(builder);this.ingress.remove(builder);} return (A)this;
    }
    public List<LoadBalancerIngress> getIngress(){
    return build(ingress);
    }
    public A withIngress( List<LoadBalancerIngress> ingress){
    this.ingress.clear();if (ingress != null) {for (LoadBalancerIngress item : ingress){this.addToIngress(item);}} return (A) this;
    }
    public A withIngress( LoadBalancerIngress ...ingress){
    this.ingress.clear(); if (ingress != null) {for (LoadBalancerIngress item :ingress){ this.addToIngress(item);}} return (A) this;
    }
    public IngressNested<A> addNewIngres(){
    return new IngressNestedImpl();
    }
    public IngressNested<A> addNewIngresLike( LoadBalancerIngress item){
    return new IngressNestedImpl(item);
    }
    public A addNewIngres( String hostname,  String ip){
    return addToIngress(new LoadBalancerIngress(hostname, ip));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
LoadBalancerStatusFluentImpl that = (LoadBalancerStatusFluentImpl) o;
if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
return true;

    }

    public class IngressNestedImpl<N> extends LoadBalancerIngressFluentImpl<IngressNested<N>> implements IngressNested<N>{

        private final LoadBalancerIngressBuilder builder;
    
             IngressNestedImpl (){
        this.builder = new LoadBalancerIngressBuilder(this);
        }
             IngressNestedImpl ( LoadBalancerIngress item){
        this.builder = new LoadBalancerIngressBuilder(this, item);
        }
    
            public N and(){
            return (N) LoadBalancerStatusFluentImpl.this.addToIngress(builder.build());
        }
            public N endIngres(){
            return and();
        }
    
}


}
