package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class MetadataFileFluentImpl<A extends MetadataFileFluent<A>> extends BaseFluent<A> implements MetadataFileFluent<A>{

     VisitableBuilder<ObjectFieldSelector, ?> fieldRef;     String name;
public MetadataFileFluentImpl(){
    
}
public MetadataFileFluentImpl( MetadataFile instance ){
    this.withFieldRef(instance.getFieldRef()); this.withName(instance.getName()); 
}

    public ObjectFieldSelector getFieldRef(){
    return this.fieldRef!=null?this.fieldRef.build():null;
    }
    public A withFieldRef( ObjectFieldSelector fieldRef){
    if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.add(this.fieldRef);} return (A) this;
    }
    public FieldRefNested<A> withNewFieldRef(){
    return new FieldRefNestedImpl();
    }
    public FieldRefNested<A> withNewFieldRefLike( ObjectFieldSelector item){
    return new FieldRefNestedImpl(item);
    }
    public FieldRefNested<A> editFieldRef(){
    return withNewFieldRefLike(getFieldRef());
    }
    public A withNewFieldRef( String apiVersion,  String fieldPath){
    return withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
    }
    public String getName(){
    return this.name;
    }
    public A withName( String name){
    this.name=name; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
MetadataFileFluentImpl that = (MetadataFileFluentImpl) o;
if (fieldRef != null ? !fieldRef.equals(that.fieldRef) :that.fieldRef != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
return true;

    }

    public class FieldRefNestedImpl<N> extends ObjectFieldSelectorFluentImpl<FieldRefNested<N>> implements FieldRefNested<N>{

        private final ObjectFieldSelectorBuilder builder;
    
             FieldRefNestedImpl (){
        this.builder = new ObjectFieldSelectorBuilder(this);
        }
             FieldRefNestedImpl ( ObjectFieldSelector item){
        this.builder = new ObjectFieldSelectorBuilder(this, item);
        }
    
            public N and(){
            return (N) MetadataFileFluentImpl.this.withFieldRef(builder.build());
        }
            public N endFieldRef(){
            return and();
        }
    
}


}
