package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NamespaceSpecFluentImpl<A extends NamespaceSpecFluent<A>> extends BaseFluent<A> implements NamespaceSpecFluent<A>{

     List<String> finalizers = new ArrayList();
public NamespaceSpecFluentImpl(){
    
}
public NamespaceSpecFluentImpl( NamespaceSpec instance ){
    this.withFinalizers(instance.getFinalizers()); 
}

    public A addToFinalizers( String ...items){
    for (String item : items) {this.finalizers.add(item);} return (A)this;
    }
    public A removeFromFinalizers( String ...items){
    for (String item : items) {this.finalizers.remove(item);} return (A)this;
    }
    public List<String> getFinalizers(){
    return this.finalizers;
    }
    public A withFinalizers( List<String> finalizers){
    this.finalizers.clear();if (finalizers != null) {for (String item : finalizers){this.addToFinalizers(item);}} return (A) this;
    }
    public A withFinalizers( String ...finalizers){
    this.finalizers.clear(); if (finalizers != null) {for (String item :finalizers){ this.addToFinalizers(item);}} return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamespaceSpecFluentImpl that = (NamespaceSpecFluentImpl) o;
if (finalizers != null ? !finalizers.equals(that.finalizers) :that.finalizers != null) return false;
return true;

    }



}
