package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

public class NodeDaemonEndpointsFluentImpl<A extends NodeDaemonEndpointsFluent<A>> extends BaseFluent<A> implements NodeDaemonEndpointsFluent<A>{

     VisitableBuilder<DaemonEndpoint, ?> kubeletEndpoint;
public NodeDaemonEndpointsFluentImpl(){
    
}
public NodeDaemonEndpointsFluentImpl( NodeDaemonEndpoints instance ){
    this.withKubeletEndpoint(instance.getKubeletEndpoint()); 
}

    public DaemonEndpoint getKubeletEndpoint(){
    return this.kubeletEndpoint!=null?this.kubeletEndpoint.build():null;
    }
    public A withKubeletEndpoint( DaemonEndpoint kubeletEndpoint){
    if (kubeletEndpoint!=null){ this.kubeletEndpoint= new DaemonEndpointBuilder(kubeletEndpoint); _visitables.add(this.kubeletEndpoint);} return (A) this;
    }
    public KubeletEndpointNested<A> withNewKubeletEndpoint(){
    return new KubeletEndpointNestedImpl();
    }
    public KubeletEndpointNested<A> withNewKubeletEndpointLike( DaemonEndpoint item){
    return new KubeletEndpointNestedImpl(item);
    }
    public KubeletEndpointNested<A> editKubeletEndpoint(){
    return withNewKubeletEndpointLike(getKubeletEndpoint());
    }
    public A withNewKubeletEndpoint( Integer Port){
    return withKubeletEndpoint(new DaemonEndpoint(Port));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NodeDaemonEndpointsFluentImpl that = (NodeDaemonEndpointsFluentImpl) o;
if (kubeletEndpoint != null ? !kubeletEndpoint.equals(that.kubeletEndpoint) :that.kubeletEndpoint != null) return false;
return true;

    }

    public class KubeletEndpointNestedImpl<N> extends DaemonEndpointFluentImpl<KubeletEndpointNested<N>> implements KubeletEndpointNested<N>{

        private final DaemonEndpointBuilder builder;
    
             KubeletEndpointNestedImpl ( DaemonEndpoint item){
        this.builder = new DaemonEndpointBuilder(this, item);
        }
             KubeletEndpointNestedImpl (){
        this.builder = new DaemonEndpointBuilder(this);
        }
    
            public N and(){
            return (N) NodeDaemonEndpointsFluentImpl.this.withKubeletEndpoint(builder.build());
        }
            public N endKubeletEndpoint(){
            return and();
        }
    
}


}
