package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface NodeFluent<A extends NodeFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public String getKind();    public A withKind( String kind);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();    public NodeSpec getSpec();    public A withSpec( NodeSpec spec);    public SpecNested<A> withNewSpec();    public SpecNested<A> withNewSpecLike( NodeSpec item);    public SpecNested<A> editSpec();    public A withNewSpec( String externalID,  String podCIDR,  String providerID,  Boolean unschedulable);    public NodeStatus getStatus();    public A withStatus( NodeStatus status);    public StatusNested<A> withNewStatus();    public StatusNested<A> withNewStatusLike( NodeStatus item);    public StatusNested<A> editStatus();
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>,NodeSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>,NodeStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
