package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface NodeListFluent<A extends NodeListFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public A addToItems( Node ...items);    public A removeFromItems( Node ...items);    public List<Node> getItems();    public A withItems( List<Node> items);    public A withItems( Node ...items);    public ItemsNested<A> addNewItem();    public ItemsNested<A> addNewItemLike( Node item);    public String getKind();    public A withKind( String kind);    public ListMeta getMetadata();    public A withMetadata( ListMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ListMeta item);    public MetadataNested<A> editMetadata();    public A withNewMetadata( String resourceVersion,  String selfLink);
    public interface ItemsNested<N> extends Nested<N>,NodeFluent<ItemsNested<N>>{
            public N endItem();            public N and();        
}

    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
