package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class NodeSpecBuilder extends NodeSpecFluentImpl<NodeSpecBuilder> implements VisitableBuilder<NodeSpec,NodeSpecBuilder>{

     NodeSpecFluent<?> fluent;
public NodeSpecBuilder(){
    this(new NodeSpec());
}
public NodeSpecBuilder( NodeSpecFluent<?> fluent ){
    this(fluent, new NodeSpec());
}
public NodeSpecBuilder( NodeSpecFluent<?> fluent , NodeSpec instance ){
    this.fluent = fluent; fluent.withExternalID(instance.getExternalID()); fluent.withPodCIDR(instance.getPodCIDR()); fluent.withProviderID(instance.getProviderID()); fluent.withUnschedulable(instance.getUnschedulable()); 
}
public NodeSpecBuilder( NodeSpec instance ){
    this.fluent = this; this.withExternalID(instance.getExternalID()); this.withPodCIDR(instance.getPodCIDR()); this.withProviderID(instance.getProviderID()); this.withUnschedulable(instance.getUnschedulable()); 
}

public NodeSpec build(){
    NodeSpec buildable = new NodeSpec(fluent.getExternalID(),fluent.getPodCIDR(),fluent.getProviderID(),fluent.isUnschedulable());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
NodeSpecBuilder that = (NodeSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
