package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface NodeStatusFluent<A extends NodeStatusFluent<A>> extends Fluent<A>{


    public A addToAddresses( NodeAddress ...items);    public A removeFromAddresses( NodeAddress ...items);    public List<NodeAddress> getAddresses();    public A withAddresses( List<NodeAddress> addresses);    public A withAddresses( NodeAddress ...addresses);    public AddressesNested<A> addNewAddresse();    public AddressesNested<A> addNewAddresseLike( NodeAddress item);    public A addNewAddresse( String address,  String type);    public A addToAllocatable( String key,  Quantity value);    public A addToAllocatable( Map<String, Quantity> map);    public A removeFromAllocatable( String key);    public A removeFromAllocatable( Map<String, Quantity> map);    public Map<String, Quantity> getAllocatable();    public A withAllocatable( Map<String, Quantity> allocatable);    public A addToCapacity( String key,  Quantity value);    public A addToCapacity( Map<String, Quantity> map);    public A removeFromCapacity( String key);    public A removeFromCapacity( Map<String, Quantity> map);    public Map<String, Quantity> getCapacity();    public A withCapacity( Map<String, Quantity> capacity);    public A addToConditions( NodeCondition ...items);    public A removeFromConditions( NodeCondition ...items);    public List<NodeCondition> getConditions();    public A withConditions( List<NodeCondition> conditions);    public A withConditions( NodeCondition ...conditions);    public ConditionsNested<A> addNewCondition();    public ConditionsNested<A> addNewConditionLike( NodeCondition item);    public NodeDaemonEndpoints getDaemonEndpoints();    public A withDaemonEndpoints( NodeDaemonEndpoints daemonEndpoints);    public DaemonEndpointsNested<A> withNewDaemonEndpoints();    public DaemonEndpointsNested<A> withNewDaemonEndpointsLike( NodeDaemonEndpoints item);    public DaemonEndpointsNested<A> editDaemonEndpoints();    public A addToImages( ContainerImage ...items);    public A removeFromImages( ContainerImage ...items);    public List<ContainerImage> getImages();    public A withImages( List<ContainerImage> images);    public A withImages( ContainerImage ...images);    public ImagesNested<A> addNewImage();    public ImagesNested<A> addNewImageLike( ContainerImage item);    public NodeSystemInfo getNodeInfo();    public A withNodeInfo( NodeSystemInfo nodeInfo);    public NodeInfoNested<A> withNewNodeInfo();    public NodeInfoNested<A> withNewNodeInfoLike( NodeSystemInfo item);    public NodeInfoNested<A> editNodeInfo();    public String getPhase();    public A withPhase( String phase);
    public interface AddressesNested<N> extends Nested<N>,NodeAddressFluent<AddressesNested<N>>{
            public N and();            public N endAddresse();        
}

    public interface ConditionsNested<N> extends Nested<N>,NodeConditionFluent<ConditionsNested<N>>{
            public N endCondition();            public N and();        
}

    public interface DaemonEndpointsNested<N> extends Nested<N>,NodeDaemonEndpointsFluent<DaemonEndpointsNested<N>>{
            public N endDaemonEndpoints();            public N and();        
}

    public interface ImagesNested<N> extends Nested<N>,ContainerImageFluent<ImagesNested<N>>{
            public N and();            public N endImage();        
}

    public interface NodeInfoNested<N> extends Nested<N>,NodeSystemInfoFluent<NodeInfoNested<N>>{
            public N and();            public N endNodeInfo();        
}


}
