package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import java.util.List;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;

public class NodeStatusFluentImpl<A extends NodeStatusFluent<A>> extends BaseFluent<A> implements NodeStatusFluent<A>{

     List<VisitableBuilder<NodeAddress, ?>> addresses = new ArrayList();     Map<String, Quantity> allocatable = new HashMap();     Map<String, Quantity> capacity = new HashMap();     List<VisitableBuilder<NodeCondition, ?>> conditions = new ArrayList();     VisitableBuilder<NodeDaemonEndpoints, ?> daemonEndpoints;     List<VisitableBuilder<ContainerImage, ?>> images = new ArrayList();     VisitableBuilder<NodeSystemInfo, ?> nodeInfo;     String phase;
public NodeStatusFluentImpl(){
    
}
public NodeStatusFluentImpl( NodeStatus instance ){
    this.withAddresses(instance.getAddresses()); this.withAllocatable(instance.getAllocatable()); this.withCapacity(instance.getCapacity()); this.withConditions(instance.getConditions()); this.withDaemonEndpoints(instance.getDaemonEndpoints()); this.withImages(instance.getImages()); this.withNodeInfo(instance.getNodeInfo()); this.withPhase(instance.getPhase()); 
}

    public A addToAddresses( NodeAddress ...items){
    for (NodeAddress item : items) {NodeAddressBuilder builder = new NodeAddressBuilder(item);_visitables.add(builder);this.addresses.add(builder);} return (A)this;
    }
    public A removeFromAddresses( NodeAddress ...items){
    for (NodeAddress item : items) {NodeAddressBuilder builder = new NodeAddressBuilder(item);_visitables.remove(builder);this.addresses.remove(builder);} return (A)this;
    }
    public List<NodeAddress> getAddresses(){
    return build(addresses);
    }
    public A withAddresses( List<NodeAddress> addresses){
    this.addresses.clear();if (addresses != null) {for (NodeAddress item : addresses){this.addToAddresses(item);}} return (A) this;
    }
    public A withAddresses( NodeAddress ...addresses){
    this.addresses.clear(); if (addresses != null) {for (NodeAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
    }
    public AddressesNested<A> addNewAddresse(){
    return new AddressesNestedImpl();
    }
    public AddressesNested<A> addNewAddresseLike( NodeAddress item){
    return new AddressesNestedImpl(item);
    }
    public A addNewAddresse( String address,  String type){
    return addToAddresses(new NodeAddress(address, type));
    }
    public A addToAllocatable( String key,  Quantity value){
    if(key != null && value != null) {this.allocatable.put(key, value);} return (A)this;
    }
    public A addToAllocatable( Map<String, Quantity> map){
    if(map != null) { this.allocatable.putAll(map);} return (A)this;
    }
    public A removeFromAllocatable( String key){
    if(key != null) {this.allocatable.remove(key);} return (A)this;
    }
    public A removeFromAllocatable( Map<String, Quantity> map){
    if(map != null) { for(Object key : map.keySet()) {this.allocatable.remove(key);}} return (A)this;
    }
    public Map<String, Quantity> getAllocatable(){
    return this.allocatable;
    }
    public A withAllocatable( Map<String, Quantity> allocatable){
    this.allocatable.clear();if (allocatable != null) {this.allocatable.putAll(allocatable);} return (A) this;
    }
    public A addToCapacity( String key,  Quantity value){
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
    }
    public A addToCapacity( Map<String, Quantity> map){
    if(map != null) { this.capacity.putAll(map);} return (A)this;
    }
    public A removeFromCapacity( String key){
    if(key != null) {this.capacity.remove(key);} return (A)this;
    }
    public A removeFromCapacity( Map<String, Quantity> map){
    if(map != null) { for(Object key : map.keySet()) {this.capacity.remove(key);}} return (A)this;
    }
    public Map<String, Quantity> getCapacity(){
    return this.capacity;
    }
    public A withCapacity( Map<String, Quantity> capacity){
    this.capacity.clear();if (capacity != null) {this.capacity.putAll(capacity);} return (A) this;
    }
    public A addToConditions( NodeCondition ...items){
    for (NodeCondition item : items) {NodeConditionBuilder builder = new NodeConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }
    public A removeFromConditions( NodeCondition ...items){
    for (NodeCondition item : items) {NodeConditionBuilder builder = new NodeConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (A)this;
    }
    public List<NodeCondition> getConditions(){
    return build(conditions);
    }
    public A withConditions( List<NodeCondition> conditions){
    this.conditions.clear();if (conditions != null) {for (NodeCondition item : conditions){this.addToConditions(item);}} return (A) this;
    }
    public A withConditions( NodeCondition ...conditions){
    this.conditions.clear(); if (conditions != null) {for (NodeCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }
    public ConditionsNested<A> addNewCondition(){
    return new ConditionsNestedImpl();
    }
    public ConditionsNested<A> addNewConditionLike( NodeCondition item){
    return new ConditionsNestedImpl(item);
    }
    public NodeDaemonEndpoints getDaemonEndpoints(){
    return this.daemonEndpoints!=null?this.daemonEndpoints.build():null;
    }
    public A withDaemonEndpoints( NodeDaemonEndpoints daemonEndpoints){
    if (daemonEndpoints!=null){ this.daemonEndpoints= new NodeDaemonEndpointsBuilder(daemonEndpoints); _visitables.add(this.daemonEndpoints);} return (A) this;
    }
    public DaemonEndpointsNested<A> withNewDaemonEndpoints(){
    return new DaemonEndpointsNestedImpl();
    }
    public DaemonEndpointsNested<A> withNewDaemonEndpointsLike( NodeDaemonEndpoints item){
    return new DaemonEndpointsNestedImpl(item);
    }
    public DaemonEndpointsNested<A> editDaemonEndpoints(){
    return withNewDaemonEndpointsLike(getDaemonEndpoints());
    }
    public A addToImages( ContainerImage ...items){
    for (ContainerImage item : items) {ContainerImageBuilder builder = new ContainerImageBuilder(item);_visitables.add(builder);this.images.add(builder);} return (A)this;
    }
    public A removeFromImages( ContainerImage ...items){
    for (ContainerImage item : items) {ContainerImageBuilder builder = new ContainerImageBuilder(item);_visitables.remove(builder);this.images.remove(builder);} return (A)this;
    }
    public List<ContainerImage> getImages(){
    return build(images);
    }
    public A withImages( List<ContainerImage> images){
    this.images.clear();if (images != null) {for (ContainerImage item : images){this.addToImages(item);}} return (A) this;
    }
    public A withImages( ContainerImage ...images){
    this.images.clear(); if (images != null) {for (ContainerImage item :images){ this.addToImages(item);}} return (A) this;
    }
    public ImagesNested<A> addNewImage(){
    return new ImagesNestedImpl();
    }
    public ImagesNested<A> addNewImageLike( ContainerImage item){
    return new ImagesNestedImpl(item);
    }
    public NodeSystemInfo getNodeInfo(){
    return this.nodeInfo!=null?this.nodeInfo.build():null;
    }
    public A withNodeInfo( NodeSystemInfo nodeInfo){
    if (nodeInfo!=null){ this.nodeInfo= new NodeSystemInfoBuilder(nodeInfo); _visitables.add(this.nodeInfo);} return (A) this;
    }
    public NodeInfoNested<A> withNewNodeInfo(){
    return new NodeInfoNestedImpl();
    }
    public NodeInfoNested<A> withNewNodeInfoLike( NodeSystemInfo item){
    return new NodeInfoNestedImpl(item);
    }
    public NodeInfoNested<A> editNodeInfo(){
    return withNewNodeInfoLike(getNodeInfo());
    }
    public String getPhase(){
    return this.phase;
    }
    public A withPhase( String phase){
    this.phase=phase; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NodeStatusFluentImpl that = (NodeStatusFluentImpl) o;
if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
if (allocatable != null ? !allocatable.equals(that.allocatable) :that.allocatable != null) return false;
if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
if (daemonEndpoints != null ? !daemonEndpoints.equals(that.daemonEndpoints) :that.daemonEndpoints != null) return false;
if (images != null ? !images.equals(that.images) :that.images != null) return false;
if (nodeInfo != null ? !nodeInfo.equals(that.nodeInfo) :that.nodeInfo != null) return false;
if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
return true;

    }

    public class AddressesNestedImpl<N> extends NodeAddressFluentImpl<AddressesNested<N>> implements AddressesNested<N>{

        private final NodeAddressBuilder builder;
    
             AddressesNestedImpl (){
        this.builder = new NodeAddressBuilder(this);
        }
             AddressesNestedImpl ( NodeAddress item){
        this.builder = new NodeAddressBuilder(this, item);
        }
    
            public N and(){
            return (N) NodeStatusFluentImpl.this.addToAddresses(builder.build());
        }
            public N endAddresse(){
            return and();
        }
    
}
    public class ConditionsNestedImpl<N> extends NodeConditionFluentImpl<ConditionsNested<N>> implements ConditionsNested<N>{

        private final NodeConditionBuilder builder;
    
             ConditionsNestedImpl (){
        this.builder = new NodeConditionBuilder(this);
        }
             ConditionsNestedImpl ( NodeCondition item){
        this.builder = new NodeConditionBuilder(this, item);
        }
    
            public N endCondition(){
            return and();
        }
            public N and(){
            return (N) NodeStatusFluentImpl.this.addToConditions(builder.build());
        }
    
}
    public class DaemonEndpointsNestedImpl<N> extends NodeDaemonEndpointsFluentImpl<DaemonEndpointsNested<N>> implements DaemonEndpointsNested<N>{

        private final NodeDaemonEndpointsBuilder builder;
    
             DaemonEndpointsNestedImpl (){
        this.builder = new NodeDaemonEndpointsBuilder(this);
        }
             DaemonEndpointsNestedImpl ( NodeDaemonEndpoints item){
        this.builder = new NodeDaemonEndpointsBuilder(this, item);
        }
    
            public N endDaemonEndpoints(){
            return and();
        }
            public N and(){
            return (N) NodeStatusFluentImpl.this.withDaemonEndpoints(builder.build());
        }
    
}
    public class ImagesNestedImpl<N> extends ContainerImageFluentImpl<ImagesNested<N>> implements ImagesNested<N>{

        private final ContainerImageBuilder builder;
    
             ImagesNestedImpl (){
        this.builder = new ContainerImageBuilder(this);
        }
             ImagesNestedImpl ( ContainerImage item){
        this.builder = new ContainerImageBuilder(this, item);
        }
    
            public N and(){
            return (N) NodeStatusFluentImpl.this.addToImages(builder.build());
        }
            public N endImage(){
            return and();
        }
    
}
    public class NodeInfoNestedImpl<N> extends NodeSystemInfoFluentImpl<NodeInfoNested<N>> implements NodeInfoNested<N>{

        private final NodeSystemInfoBuilder builder;
    
             NodeInfoNestedImpl ( NodeSystemInfo item){
        this.builder = new NodeSystemInfoBuilder(this, item);
        }
             NodeInfoNestedImpl (){
        this.builder = new NodeSystemInfoBuilder(this);
        }
    
            public N and(){
            return (N) NodeStatusFluentImpl.this.withNodeInfo(builder.build());
        }
            public N endNodeInfo(){
            return and();
        }
    
}


}
