package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class PersistentVolumeClaimStatusBuilder extends PersistentVolumeClaimStatusFluentImpl<PersistentVolumeClaimStatusBuilder> implements VisitableBuilder<PersistentVolumeClaimStatus,PersistentVolumeClaimStatusBuilder>{

     PersistentVolumeClaimStatusFluent<?> fluent;
public PersistentVolumeClaimStatusBuilder(){
    this(new PersistentVolumeClaimStatus());
}
public PersistentVolumeClaimStatusBuilder( PersistentVolumeClaimStatusFluent<?> fluent ){
    this(fluent, new PersistentVolumeClaimStatus());
}
public PersistentVolumeClaimStatusBuilder( PersistentVolumeClaimStatusFluent<?> fluent , PersistentVolumeClaimStatus instance ){
    this.fluent = fluent; fluent.withAccessModes(instance.getAccessModes()); fluent.withCapacity(instance.getCapacity()); fluent.withPhase(instance.getPhase()); 
}
public PersistentVolumeClaimStatusBuilder( PersistentVolumeClaimStatus instance ){
    this.fluent = this; this.withAccessModes(instance.getAccessModes()); this.withCapacity(instance.getCapacity()); this.withPhase(instance.getPhase()); 
}

public PersistentVolumeClaimStatus build(){
    PersistentVolumeClaimStatus buildable = new PersistentVolumeClaimStatus(fluent.getAccessModes(),fluent.getCapacity(),fluent.getPhase());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PersistentVolumeClaimStatusBuilder that = (PersistentVolumeClaimStatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
