
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "accessModes",
    "awsElasticBlockStore",
    "azureFile",
    "capacity",
    "cephfs",
    "cinder",
    "claimRef",
    "fc",
    "flexVolume",
    "flocker",
    "gcePersistentDisk",
    "glusterfs",
    "hostPath",
    "iscsi",
    "nfs",
    "persistentVolumeReclaimPolicy",
    "rbd"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class PersistentVolumeSpec {

    /**
     * 
     * 
     */
    @JsonProperty("accessModes")
    @Valid
    private List<java.lang.String> accessModes = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("awsElasticBlockStore")
    @Valid
    private AWSElasticBlockStoreVolumeSource awsElasticBlockStore;
    /**
     * 
     * 
     */
    @JsonProperty("azureFile")
    @Valid
    private AzureFileVolumeSource azureFile;
    /**
     * 
     * 
     */
    @JsonProperty("capacity")
    @Valid
    private Map<String, Quantity> capacity;
    /**
     * 
     * 
     */
    @JsonProperty("cephfs")
    @Valid
    private CephFSVolumeSource cephfs;
    /**
     * 
     * 
     */
    @JsonProperty("cinder")
    @Valid
    private CinderVolumeSource cinder;
    /**
     * 
     * 
     */
    @JsonProperty("claimRef")
    @Valid
    private ObjectReference claimRef;
    /**
     * 
     * 
     */
    @JsonProperty("fc")
    @Valid
    private FCVolumeSource fc;
    /**
     * 
     * 
     */
    @JsonProperty("flexVolume")
    @Valid
    private FlexVolumeSource flexVolume;
    /**
     * 
     * 
     */
    @JsonProperty("flocker")
    @Valid
    private FlockerVolumeSource flocker;
    /**
     * 
     * 
     */
    @JsonProperty("gcePersistentDisk")
    @Valid
    private GCEPersistentDiskVolumeSource gcePersistentDisk;
    /**
     * 
     * 
     */
    @JsonProperty("glusterfs")
    @Valid
    private GlusterfsVolumeSource glusterfs;
    /**
     * 
     * 
     */
    @JsonProperty("hostPath")
    @Valid
    private HostPathVolumeSource hostPath;
    /**
     * 
     * 
     */
    @JsonProperty("iscsi")
    @Valid
    private ISCSIVolumeSource iscsi;
    /**
     * 
     * 
     */
    @JsonProperty("nfs")
    @Valid
    private NFSVolumeSource nfs;
    /**
     * 
     * 
     */
    @JsonProperty("persistentVolumeReclaimPolicy")
    private java.lang.String persistentVolumeReclaimPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("rbd")
    @Valid
    private RBDVolumeSource rbd;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PersistentVolumeSpec() {
    }

    /**
     * 
     * @param gcePersistentDisk
     * @param claimRef
     * @param cinder
     * @param azureFile
     * @param awsElasticBlockStore
     * @param flexVolume
     * @param capacity
     * @param flocker
     * @param iscsi
     * @param cephfs
     * @param rbd
     * @param nfs
     * @param persistentVolumeReclaimPolicy
     * @param accessModes
     * @param glusterfs
     * @param fc
     * @param hostPath
     */
    public PersistentVolumeSpec(List<java.lang.String> accessModes, AWSElasticBlockStoreVolumeSource awsElasticBlockStore, AzureFileVolumeSource azureFile, Map<String, Quantity> capacity, CephFSVolumeSource cephfs, CinderVolumeSource cinder, ObjectReference claimRef, FCVolumeSource fc, FlexVolumeSource flexVolume, FlockerVolumeSource flocker, GCEPersistentDiskVolumeSource gcePersistentDisk, GlusterfsVolumeSource glusterfs, HostPathVolumeSource hostPath, ISCSIVolumeSource iscsi, NFSVolumeSource nfs, java.lang.String persistentVolumeReclaimPolicy, RBDVolumeSource rbd) {
        this.accessModes = accessModes;
        this.awsElasticBlockStore = awsElasticBlockStore;
        this.azureFile = azureFile;
        this.capacity = capacity;
        this.cephfs = cephfs;
        this.cinder = cinder;
        this.claimRef = claimRef;
        this.fc = fc;
        this.flexVolume = flexVolume;
        this.flocker = flocker;
        this.gcePersistentDisk = gcePersistentDisk;
        this.glusterfs = glusterfs;
        this.hostPath = hostPath;
        this.iscsi = iscsi;
        this.nfs = nfs;
        this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
        this.rbd = rbd;
    }

    /**
     * 
     * 
     * @return
     *     The accessModes
     */
    @JsonProperty("accessModes")
    public List<java.lang.String> getAccessModes() {
        return accessModes;
    }

    /**
     * 
     * 
     * @param accessModes
     *     The accessModes
     */
    @JsonProperty("accessModes")
    public void setAccessModes(List<java.lang.String> accessModes) {
        this.accessModes = accessModes;
    }

    /**
     * 
     * 
     * @return
     *     The awsElasticBlockStore
     */
    @JsonProperty("awsElasticBlockStore")
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return awsElasticBlockStore;
    }

    /**
     * 
     * 
     * @param awsElasticBlockStore
     *     The awsElasticBlockStore
     */
    @JsonProperty("awsElasticBlockStore")
    public void setAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        this.awsElasticBlockStore = awsElasticBlockStore;
    }

    /**
     * 
     * 
     * @return
     *     The azureFile
     */
    @JsonProperty("azureFile")
    public AzureFileVolumeSource getAzureFile() {
        return azureFile;
    }

    /**
     * 
     * 
     * @param azureFile
     *     The azureFile
     */
    @JsonProperty("azureFile")
    public void setAzureFile(AzureFileVolumeSource azureFile) {
        this.azureFile = azureFile;
    }

    /**
     * 
     * 
     * @return
     *     The capacity
     */
    @JsonProperty("capacity")
    public Map<String, Quantity> getCapacity() {
        return capacity;
    }

    /**
     * 
     * 
     * @param capacity
     *     The capacity
     */
    @JsonProperty("capacity")
    public void setCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
    }

    /**
     * 
     * 
     * @return
     *     The cephfs
     */
    @JsonProperty("cephfs")
    public CephFSVolumeSource getCephfs() {
        return cephfs;
    }

    /**
     * 
     * 
     * @param cephfs
     *     The cephfs
     */
    @JsonProperty("cephfs")
    public void setCephfs(CephFSVolumeSource cephfs) {
        this.cephfs = cephfs;
    }

    /**
     * 
     * 
     * @return
     *     The cinder
     */
    @JsonProperty("cinder")
    public CinderVolumeSource getCinder() {
        return cinder;
    }

    /**
     * 
     * 
     * @param cinder
     *     The cinder
     */
    @JsonProperty("cinder")
    public void setCinder(CinderVolumeSource cinder) {
        this.cinder = cinder;
    }

    /**
     * 
     * 
     * @return
     *     The claimRef
     */
    @JsonProperty("claimRef")
    public ObjectReference getClaimRef() {
        return claimRef;
    }

    /**
     * 
     * 
     * @param claimRef
     *     The claimRef
     */
    @JsonProperty("claimRef")
    public void setClaimRef(ObjectReference claimRef) {
        this.claimRef = claimRef;
    }

    /**
     * 
     * 
     * @return
     *     The fc
     */
    @JsonProperty("fc")
    public FCVolumeSource getFc() {
        return fc;
    }

    /**
     * 
     * 
     * @param fc
     *     The fc
     */
    @JsonProperty("fc")
    public void setFc(FCVolumeSource fc) {
        this.fc = fc;
    }

    /**
     * 
     * 
     * @return
     *     The flexVolume
     */
    @JsonProperty("flexVolume")
    public FlexVolumeSource getFlexVolume() {
        return flexVolume;
    }

    /**
     * 
     * 
     * @param flexVolume
     *     The flexVolume
     */
    @JsonProperty("flexVolume")
    public void setFlexVolume(FlexVolumeSource flexVolume) {
        this.flexVolume = flexVolume;
    }

    /**
     * 
     * 
     * @return
     *     The flocker
     */
    @JsonProperty("flocker")
    public FlockerVolumeSource getFlocker() {
        return flocker;
    }

    /**
     * 
     * 
     * @param flocker
     *     The flocker
     */
    @JsonProperty("flocker")
    public void setFlocker(FlockerVolumeSource flocker) {
        this.flocker = flocker;
    }

    /**
     * 
     * 
     * @return
     *     The gcePersistentDisk
     */
    @JsonProperty("gcePersistentDisk")
    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return gcePersistentDisk;
    }

    /**
     * 
     * 
     * @param gcePersistentDisk
     *     The gcePersistentDisk
     */
    @JsonProperty("gcePersistentDisk")
    public void setGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        this.gcePersistentDisk = gcePersistentDisk;
    }

    /**
     * 
     * 
     * @return
     *     The glusterfs
     */
    @JsonProperty("glusterfs")
    public GlusterfsVolumeSource getGlusterfs() {
        return glusterfs;
    }

    /**
     * 
     * 
     * @param glusterfs
     *     The glusterfs
     */
    @JsonProperty("glusterfs")
    public void setGlusterfs(GlusterfsVolumeSource glusterfs) {
        this.glusterfs = glusterfs;
    }

    /**
     * 
     * 
     * @return
     *     The hostPath
     */
    @JsonProperty("hostPath")
    public HostPathVolumeSource getHostPath() {
        return hostPath;
    }

    /**
     * 
     * 
     * @param hostPath
     *     The hostPath
     */
    @JsonProperty("hostPath")
    public void setHostPath(HostPathVolumeSource hostPath) {
        this.hostPath = hostPath;
    }

    /**
     * 
     * 
     * @return
     *     The iscsi
     */
    @JsonProperty("iscsi")
    public ISCSIVolumeSource getIscsi() {
        return iscsi;
    }

    /**
     * 
     * 
     * @param iscsi
     *     The iscsi
     */
    @JsonProperty("iscsi")
    public void setIscsi(ISCSIVolumeSource iscsi) {
        this.iscsi = iscsi;
    }

    /**
     * 
     * 
     * @return
     *     The nfs
     */
    @JsonProperty("nfs")
    public NFSVolumeSource getNfs() {
        return nfs;
    }

    /**
     * 
     * 
     * @param nfs
     *     The nfs
     */
    @JsonProperty("nfs")
    public void setNfs(NFSVolumeSource nfs) {
        this.nfs = nfs;
    }

    /**
     * 
     * 
     * @return
     *     The persistentVolumeReclaimPolicy
     */
    @JsonProperty("persistentVolumeReclaimPolicy")
    public java.lang.String getPersistentVolumeReclaimPolicy() {
        return persistentVolumeReclaimPolicy;
    }

    /**
     * 
     * 
     * @param persistentVolumeReclaimPolicy
     *     The persistentVolumeReclaimPolicy
     */
    @JsonProperty("persistentVolumeReclaimPolicy")
    public void setPersistentVolumeReclaimPolicy(java.lang.String persistentVolumeReclaimPolicy) {
        this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
    }

    /**
     * 
     * 
     * @return
     *     The rbd
     */
    @JsonProperty("rbd")
    public RBDVolumeSource getRbd() {
        return rbd;
    }

    /**
     * 
     * 
     * @param rbd
     *     The rbd
     */
    @JsonProperty("rbd")
    public void setRbd(RBDVolumeSource rbd) {
        this.rbd = rbd;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
