package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class PersistentVolumeSpecFluentImpl<A extends PersistentVolumeSpecFluent<A>> extends BaseFluent<A> implements PersistentVolumeSpecFluent<A>{

     List<String> accessModes = new ArrayList();     VisitableBuilder<AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;     VisitableBuilder<AzureFileVolumeSource, ?> azureFile;     Map<String, Quantity> capacity = new HashMap();     VisitableBuilder<CephFSVolumeSource, ?> cephfs;     VisitableBuilder<CinderVolumeSource, ?> cinder;     VisitableBuilder<ObjectReference, ?> claimRef;     VisitableBuilder<FCVolumeSource, ?> fc;     VisitableBuilder<FlexVolumeSource, ?> flexVolume;     VisitableBuilder<FlockerVolumeSource, ?> flocker;     VisitableBuilder<GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;     VisitableBuilder<GlusterfsVolumeSource, ?> glusterfs;     VisitableBuilder<HostPathVolumeSource, ?> hostPath;     VisitableBuilder<ISCSIVolumeSource, ?> iscsi;     VisitableBuilder<NFSVolumeSource, ?> nfs;     String persistentVolumeReclaimPolicy;     VisitableBuilder<RBDVolumeSource, ?> rbd;
public PersistentVolumeSpecFluentImpl(){
    
}
public PersistentVolumeSpecFluentImpl( PersistentVolumeSpec instance ){
    this.withAccessModes(instance.getAccessModes()); this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); this.withAzureFile(instance.getAzureFile()); this.withCapacity(instance.getCapacity()); this.withCephfs(instance.getCephfs()); this.withCinder(instance.getCinder()); this.withClaimRef(instance.getClaimRef()); this.withFc(instance.getFc()); this.withFlexVolume(instance.getFlexVolume()); this.withFlocker(instance.getFlocker()); this.withGcePersistentDisk(instance.getGcePersistentDisk()); this.withGlusterfs(instance.getGlusterfs()); this.withHostPath(instance.getHostPath()); this.withIscsi(instance.getIscsi()); this.withNfs(instance.getNfs()); this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy()); this.withRbd(instance.getRbd()); 
}

    public A addToAccessModes( String ...items){
    for (String item : items) {this.accessModes.add(item);} return (A)this;
    }
    public A removeFromAccessModes( String ...items){
    for (String item : items) {this.accessModes.remove(item);} return (A)this;
    }
    public List<String> getAccessModes(){
    return this.accessModes;
    }
    public A withAccessModes( List<String> accessModes){
    this.accessModes.clear();if (accessModes != null) {for (String item : accessModes){this.addToAccessModes(item);}} return (A) this;
    }
    public A withAccessModes( String ...accessModes){
    this.accessModes.clear(); if (accessModes != null) {for (String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
    }
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore(){
    return this.awsElasticBlockStore!=null?this.awsElasticBlockStore.build():null;
    }
    public A withAwsElasticBlockStore( AWSElasticBlockStoreVolumeSource awsElasticBlockStore){
    if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.add(this.awsElasticBlockStore);} return (A) this;
    }
    public AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore(){
    return new AwsElasticBlockStoreNestedImpl();
    }
    public AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike( AWSElasticBlockStoreVolumeSource item){
    return new AwsElasticBlockStoreNestedImpl(item);
    }
    public AwsElasticBlockStoreNested<A> editAwsElasticBlockStore(){
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore());
    }
    public A withNewAwsElasticBlockStore( String fsType,  Integer partition,  Boolean readOnly,  String volumeID){
    return withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }
    public AzureFileVolumeSource getAzureFile(){
    return this.azureFile!=null?this.azureFile.build():null;
    }
    public A withAzureFile( AzureFileVolumeSource azureFile){
    if (azureFile!=null){ this.azureFile= new AzureFileVolumeSourceBuilder(azureFile); _visitables.add(this.azureFile);} return (A) this;
    }
    public AzureFileNested<A> withNewAzureFile(){
    return new AzureFileNestedImpl();
    }
    public AzureFileNested<A> withNewAzureFileLike( AzureFileVolumeSource item){
    return new AzureFileNestedImpl(item);
    }
    public AzureFileNested<A> editAzureFile(){
    return withNewAzureFileLike(getAzureFile());
    }
    public A withNewAzureFile( Boolean readOnly,  String secretName,  String shareName){
    return withAzureFile(new AzureFileVolumeSource(readOnly, secretName, shareName));
    }
    public A addToCapacity( String key,  Quantity value){
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
    }
    public A addToCapacity( Map<String, Quantity> map){
    if(map != null) { this.capacity.putAll(map);} return (A)this;
    }
    public A removeFromCapacity( String key){
    if(key != null) {this.capacity.remove(key);} return (A)this;
    }
    public A removeFromCapacity( Map<String, Quantity> map){
    if(map != null) { for(Object key : map.keySet()) {this.capacity.remove(key);}} return (A)this;
    }
    public Map<String, Quantity> getCapacity(){
    return this.capacity;
    }
    public A withCapacity( Map<String, Quantity> capacity){
    this.capacity.clear();if (capacity != null) {this.capacity.putAll(capacity);} return (A) this;
    }
    public CephFSVolumeSource getCephfs(){
    return this.cephfs!=null?this.cephfs.build():null;
    }
    public A withCephfs( CephFSVolumeSource cephfs){
    if (cephfs!=null){ this.cephfs= new CephFSVolumeSourceBuilder(cephfs); _visitables.add(this.cephfs);} return (A) this;
    }
    public CephfsNested<A> withNewCephfs(){
    return new CephfsNestedImpl();
    }
    public CephfsNested<A> withNewCephfsLike( CephFSVolumeSource item){
    return new CephfsNestedImpl(item);
    }
    public CephfsNested<A> editCephfs(){
    return withNewCephfsLike(getCephfs());
    }
    public CinderVolumeSource getCinder(){
    return this.cinder!=null?this.cinder.build():null;
    }
    public A withCinder( CinderVolumeSource cinder){
    if (cinder!=null){ this.cinder= new CinderVolumeSourceBuilder(cinder); _visitables.add(this.cinder);} return (A) this;
    }
    public CinderNested<A> withNewCinder(){
    return new CinderNestedImpl();
    }
    public CinderNested<A> withNewCinderLike( CinderVolumeSource item){
    return new CinderNestedImpl(item);
    }
    public CinderNested<A> editCinder(){
    return withNewCinderLike(getCinder());
    }
    public A withNewCinder( String fsType,  Boolean readOnly,  String volumeID){
    return withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }
    public ObjectReference getClaimRef(){
    return this.claimRef!=null?this.claimRef.build():null;
    }
    public A withClaimRef( ObjectReference claimRef){
    if (claimRef!=null){ this.claimRef= new ObjectReferenceBuilder(claimRef); _visitables.add(this.claimRef);} return (A) this;
    }
    public ClaimRefNested<A> withNewClaimRef(){
    return new ClaimRefNestedImpl();
    }
    public ClaimRefNested<A> withNewClaimRefLike( ObjectReference item){
    return new ClaimRefNestedImpl(item);
    }
    public ClaimRefNested<A> editClaimRef(){
    return withNewClaimRefLike(getClaimRef());
    }
    public FCVolumeSource getFc(){
    return this.fc!=null?this.fc.build():null;
    }
    public A withFc( FCVolumeSource fc){
    if (fc!=null){ this.fc= new FCVolumeSourceBuilder(fc); _visitables.add(this.fc);} return (A) this;
    }
    public FcNested<A> withNewFc(){
    return new FcNestedImpl();
    }
    public FcNested<A> withNewFcLike( FCVolumeSource item){
    return new FcNestedImpl(item);
    }
    public FcNested<A> editFc(){
    return withNewFcLike(getFc());
    }
    public FlexVolumeSource getFlexVolume(){
    return this.flexVolume!=null?this.flexVolume.build():null;
    }
    public A withFlexVolume( FlexVolumeSource flexVolume){
    if (flexVolume!=null){ this.flexVolume= new FlexVolumeSourceBuilder(flexVolume); _visitables.add(this.flexVolume);} return (A) this;
    }
    public FlexVolumeNested<A> withNewFlexVolume(){
    return new FlexVolumeNestedImpl();
    }
    public FlexVolumeNested<A> withNewFlexVolumeLike( FlexVolumeSource item){
    return new FlexVolumeNestedImpl(item);
    }
    public FlexVolumeNested<A> editFlexVolume(){
    return withNewFlexVolumeLike(getFlexVolume());
    }
    public FlockerVolumeSource getFlocker(){
    return this.flocker!=null?this.flocker.build():null;
    }
    public A withFlocker( FlockerVolumeSource flocker){
    if (flocker!=null){ this.flocker= new FlockerVolumeSourceBuilder(flocker); _visitables.add(this.flocker);} return (A) this;
    }
    public FlockerNested<A> withNewFlocker(){
    return new FlockerNestedImpl();
    }
    public FlockerNested<A> withNewFlockerLike( FlockerVolumeSource item){
    return new FlockerNestedImpl(item);
    }
    public FlockerNested<A> editFlocker(){
    return withNewFlockerLike(getFlocker());
    }
    public A withNewFlocker( String datasetName){
    return withFlocker(new FlockerVolumeSource(datasetName));
    }
    public GCEPersistentDiskVolumeSource getGcePersistentDisk(){
    return this.gcePersistentDisk!=null?this.gcePersistentDisk.build():null;
    }
    public A withGcePersistentDisk( GCEPersistentDiskVolumeSource gcePersistentDisk){
    if (gcePersistentDisk!=null){ this.gcePersistentDisk= new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.add(this.gcePersistentDisk);} return (A) this;
    }
    public GcePersistentDiskNested<A> withNewGcePersistentDisk(){
    return new GcePersistentDiskNestedImpl();
    }
    public GcePersistentDiskNested<A> withNewGcePersistentDiskLike( GCEPersistentDiskVolumeSource item){
    return new GcePersistentDiskNestedImpl(item);
    }
    public GcePersistentDiskNested<A> editGcePersistentDisk(){
    return withNewGcePersistentDiskLike(getGcePersistentDisk());
    }
    public A withNewGcePersistentDisk( String fsType,  Integer partition,  String pdName,  Boolean readOnly){
    return withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }
    public GlusterfsVolumeSource getGlusterfs(){
    return this.glusterfs!=null?this.glusterfs.build():null;
    }
    public A withGlusterfs( GlusterfsVolumeSource glusterfs){
    if (glusterfs!=null){ this.glusterfs= new GlusterfsVolumeSourceBuilder(glusterfs); _visitables.add(this.glusterfs);} return (A) this;
    }
    public GlusterfsNested<A> withNewGlusterfs(){
    return new GlusterfsNestedImpl();
    }
    public GlusterfsNested<A> withNewGlusterfsLike( GlusterfsVolumeSource item){
    return new GlusterfsNestedImpl(item);
    }
    public GlusterfsNested<A> editGlusterfs(){
    return withNewGlusterfsLike(getGlusterfs());
    }
    public A withNewGlusterfs( String endpoints,  String path,  Boolean readOnly){
    return withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }
    public HostPathVolumeSource getHostPath(){
    return this.hostPath!=null?this.hostPath.build():null;
    }
    public A withHostPath( HostPathVolumeSource hostPath){
    if (hostPath!=null){ this.hostPath= new HostPathVolumeSourceBuilder(hostPath); _visitables.add(this.hostPath);} return (A) this;
    }
    public HostPathNested<A> withNewHostPath(){
    return new HostPathNestedImpl();
    }
    public HostPathNested<A> withNewHostPathLike( HostPathVolumeSource item){
    return new HostPathNestedImpl(item);
    }
    public HostPathNested<A> editHostPath(){
    return withNewHostPathLike(getHostPath());
    }
    public A withNewHostPath( String path){
    return withHostPath(new HostPathVolumeSource(path));
    }
    public ISCSIVolumeSource getIscsi(){
    return this.iscsi!=null?this.iscsi.build():null;
    }
    public A withIscsi( ISCSIVolumeSource iscsi){
    if (iscsi!=null){ this.iscsi= new ISCSIVolumeSourceBuilder(iscsi); _visitables.add(this.iscsi);} return (A) this;
    }
    public IscsiNested<A> withNewIscsi(){
    return new IscsiNestedImpl();
    }
    public IscsiNested<A> withNewIscsiLike( ISCSIVolumeSource item){
    return new IscsiNestedImpl(item);
    }
    public IscsiNested<A> editIscsi(){
    return withNewIscsiLike(getIscsi());
    }
    public NFSVolumeSource getNfs(){
    return this.nfs!=null?this.nfs.build():null;
    }
    public A withNfs( NFSVolumeSource nfs){
    if (nfs!=null){ this.nfs= new NFSVolumeSourceBuilder(nfs); _visitables.add(this.nfs);} return (A) this;
    }
    public NfsNested<A> withNewNfs(){
    return new NfsNestedImpl();
    }
    public NfsNested<A> withNewNfsLike( NFSVolumeSource item){
    return new NfsNestedImpl(item);
    }
    public NfsNested<A> editNfs(){
    return withNewNfsLike(getNfs());
    }
    public A withNewNfs( String path,  Boolean readOnly,  String server){
    return withNfs(new NFSVolumeSource(path, readOnly, server));
    }
    public String getPersistentVolumeReclaimPolicy(){
    return this.persistentVolumeReclaimPolicy;
    }
    public A withPersistentVolumeReclaimPolicy( String persistentVolumeReclaimPolicy){
    this.persistentVolumeReclaimPolicy=persistentVolumeReclaimPolicy; return (A) this;
    }
    public RBDVolumeSource getRbd(){
    return this.rbd!=null?this.rbd.build():null;
    }
    public A withRbd( RBDVolumeSource rbd){
    if (rbd!=null){ this.rbd= new RBDVolumeSourceBuilder(rbd); _visitables.add(this.rbd);} return (A) this;
    }
    public RbdNested<A> withNewRbd(){
    return new RbdNestedImpl();
    }
    public RbdNested<A> withNewRbdLike( RBDVolumeSource item){
    return new RbdNestedImpl(item);
    }
    public RbdNested<A> editRbd(){
    return withNewRbdLike(getRbd());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PersistentVolumeSpecFluentImpl that = (PersistentVolumeSpecFluentImpl) o;
if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
if (awsElasticBlockStore != null ? !awsElasticBlockStore.equals(that.awsElasticBlockStore) :that.awsElasticBlockStore != null) return false;
if (azureFile != null ? !azureFile.equals(that.azureFile) :that.azureFile != null) return false;
if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
if (cephfs != null ? !cephfs.equals(that.cephfs) :that.cephfs != null) return false;
if (cinder != null ? !cinder.equals(that.cinder) :that.cinder != null) return false;
if (claimRef != null ? !claimRef.equals(that.claimRef) :that.claimRef != null) return false;
if (fc != null ? !fc.equals(that.fc) :that.fc != null) return false;
if (flexVolume != null ? !flexVolume.equals(that.flexVolume) :that.flexVolume != null) return false;
if (flocker != null ? !flocker.equals(that.flocker) :that.flocker != null) return false;
if (gcePersistentDisk != null ? !gcePersistentDisk.equals(that.gcePersistentDisk) :that.gcePersistentDisk != null) return false;
if (glusterfs != null ? !glusterfs.equals(that.glusterfs) :that.glusterfs != null) return false;
if (hostPath != null ? !hostPath.equals(that.hostPath) :that.hostPath != null) return false;
if (iscsi != null ? !iscsi.equals(that.iscsi) :that.iscsi != null) return false;
if (nfs != null ? !nfs.equals(that.nfs) :that.nfs != null) return false;
if (persistentVolumeReclaimPolicy != null ? !persistentVolumeReclaimPolicy.equals(that.persistentVolumeReclaimPolicy) :that.persistentVolumeReclaimPolicy != null) return false;
if (rbd != null ? !rbd.equals(that.rbd) :that.rbd != null) return false;
return true;

    }

    public class AwsElasticBlockStoreNestedImpl<N> extends AWSElasticBlockStoreVolumeSourceFluentImpl<AwsElasticBlockStoreNested<N>> implements AwsElasticBlockStoreNested<N>{

        private final AWSElasticBlockStoreVolumeSourceBuilder builder;
    
             AwsElasticBlockStoreNestedImpl (){
        this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }
             AwsElasticBlockStoreNestedImpl ( AWSElasticBlockStoreVolumeSource item){
        this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }
    
            public N endAwsElasticBlockStore(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withAwsElasticBlockStore(builder.build());
        }
    
}
    public class AzureFileNestedImpl<N> extends AzureFileVolumeSourceFluentImpl<AzureFileNested<N>> implements AzureFileNested<N>{

        private final AzureFileVolumeSourceBuilder builder;
    
             AzureFileNestedImpl ( AzureFileVolumeSource item){
        this.builder = new AzureFileVolumeSourceBuilder(this, item);
        }
             AzureFileNestedImpl (){
        this.builder = new AzureFileVolumeSourceBuilder(this);
        }
    
            public N endAzureFile(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withAzureFile(builder.build());
        }
    
}
    public class CephfsNestedImpl<N> extends CephFSVolumeSourceFluentImpl<CephfsNested<N>> implements CephfsNested<N>{

        private final CephFSVolumeSourceBuilder builder;
    
             CephfsNestedImpl (){
        this.builder = new CephFSVolumeSourceBuilder(this);
        }
             CephfsNestedImpl ( CephFSVolumeSource item){
        this.builder = new CephFSVolumeSourceBuilder(this, item);
        }
    
            public N endCephfs(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withCephfs(builder.build());
        }
    
}
    public class CinderNestedImpl<N> extends CinderVolumeSourceFluentImpl<CinderNested<N>> implements CinderNested<N>{

        private final CinderVolumeSourceBuilder builder;
    
             CinderNestedImpl (){
        this.builder = new CinderVolumeSourceBuilder(this);
        }
             CinderNestedImpl ( CinderVolumeSource item){
        this.builder = new CinderVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withCinder(builder.build());
        }
            public N endCinder(){
            return and();
        }
    
}
    public class ClaimRefNestedImpl<N> extends ObjectReferenceFluentImpl<ClaimRefNested<N>> implements ClaimRefNested<N>{

        private final ObjectReferenceBuilder builder;
    
             ClaimRefNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ClaimRefNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withClaimRef(builder.build());
        }
            public N endClaimRef(){
            return and();
        }
    
}
    public class FcNestedImpl<N> extends FCVolumeSourceFluentImpl<FcNested<N>> implements FcNested<N>{

        private final FCVolumeSourceBuilder builder;
    
             FcNestedImpl (){
        this.builder = new FCVolumeSourceBuilder(this);
        }
             FcNestedImpl ( FCVolumeSource item){
        this.builder = new FCVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withFc(builder.build());
        }
            public N endFc(){
            return and();
        }
    
}
    public class FlexVolumeNestedImpl<N> extends FlexVolumeSourceFluentImpl<FlexVolumeNested<N>> implements FlexVolumeNested<N>{

        private final FlexVolumeSourceBuilder builder;
    
             FlexVolumeNestedImpl (){
        this.builder = new FlexVolumeSourceBuilder(this);
        }
             FlexVolumeNestedImpl ( FlexVolumeSource item){
        this.builder = new FlexVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withFlexVolume(builder.build());
        }
            public N endFlexVolume(){
            return and();
        }
    
}
    public class FlockerNestedImpl<N> extends FlockerVolumeSourceFluentImpl<FlockerNested<N>> implements FlockerNested<N>{

        private final FlockerVolumeSourceBuilder builder;
    
             FlockerNestedImpl (){
        this.builder = new FlockerVolumeSourceBuilder(this);
        }
             FlockerNestedImpl ( FlockerVolumeSource item){
        this.builder = new FlockerVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withFlocker(builder.build());
        }
            public N endFlocker(){
            return and();
        }
    
}
    public class GcePersistentDiskNestedImpl<N> extends GCEPersistentDiskVolumeSourceFluentImpl<GcePersistentDiskNested<N>> implements GcePersistentDiskNested<N>{

        private final GCEPersistentDiskVolumeSourceBuilder builder;
    
             GcePersistentDiskNestedImpl (){
        this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }
             GcePersistentDiskNestedImpl ( GCEPersistentDiskVolumeSource item){
        this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }
    
            public N endGcePersistentDisk(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withGcePersistentDisk(builder.build());
        }
    
}
    public class GlusterfsNestedImpl<N> extends GlusterfsVolumeSourceFluentImpl<GlusterfsNested<N>> implements GlusterfsNested<N>{

        private final GlusterfsVolumeSourceBuilder builder;
    
             GlusterfsNestedImpl (){
        this.builder = new GlusterfsVolumeSourceBuilder(this);
        }
             GlusterfsNestedImpl ( GlusterfsVolumeSource item){
        this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withGlusterfs(builder.build());
        }
            public N endGlusterfs(){
            return and();
        }
    
}
    public class HostPathNestedImpl<N> extends HostPathVolumeSourceFluentImpl<HostPathNested<N>> implements HostPathNested<N>{

        private final HostPathVolumeSourceBuilder builder;
    
             HostPathNestedImpl (){
        this.builder = new HostPathVolumeSourceBuilder(this);
        }
             HostPathNestedImpl ( HostPathVolumeSource item){
        this.builder = new HostPathVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withHostPath(builder.build());
        }
            public N endHostPath(){
            return and();
        }
    
}
    public class IscsiNestedImpl<N> extends ISCSIVolumeSourceFluentImpl<IscsiNested<N>> implements IscsiNested<N>{

        private final ISCSIVolumeSourceBuilder builder;
    
             IscsiNestedImpl ( ISCSIVolumeSource item){
        this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }
             IscsiNestedImpl (){
        this.builder = new ISCSIVolumeSourceBuilder(this);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withIscsi(builder.build());
        }
            public N endIscsi(){
            return and();
        }
    
}
    public class NfsNestedImpl<N> extends NFSVolumeSourceFluentImpl<NfsNested<N>> implements NfsNested<N>{

        private final NFSVolumeSourceBuilder builder;
    
             NfsNestedImpl ( NFSVolumeSource item){
        this.builder = new NFSVolumeSourceBuilder(this, item);
        }
             NfsNestedImpl (){
        this.builder = new NFSVolumeSourceBuilder(this);
        }
    
            public N endNfs(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withNfs(builder.build());
        }
    
}
    public class RbdNestedImpl<N> extends RBDVolumeSourceFluentImpl<RbdNested<N>> implements RbdNested<N>{

        private final RBDVolumeSourceBuilder builder;
    
             RbdNestedImpl (){
        this.builder = new RBDVolumeSourceBuilder(this);
        }
             RbdNestedImpl ( RBDVolumeSource item){
        this.builder = new RBDVolumeSourceBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withRbd(builder.build());
        }
            public N endRbd(){
            return and();
        }
    
}


}
